/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.enchantments;

import org.apache.commons.lang.Validate;
import org.bukkit.enchantments.Enchantment;
import org.jetbrains.annotations.NotNull;

public class EnchantmentOffer {
    private Enchantment enchantment;
    private int enchantmentLevel;
    private int cost;

    public EnchantmentOffer(@NotNull Enchantment enchantment, int enchantmentLevel, int cost) {
        this.enchantment = enchantment;
        this.enchantmentLevel = enchantmentLevel;
        this.cost = cost;
    }

    @NotNull
    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public void setEnchantment(@NotNull Enchantment enchantment) {
        Validate.notNull((Object)enchantment, (String)"The enchantment may not be null!");
        this.enchantment = enchantment;
    }

    public int getEnchantmentLevel() {
        return this.enchantmentLevel;
    }

    public void setEnchantmentLevel(int enchantmentLevel) {
        Validate.isTrue((enchantmentLevel > 0 ? 1 : 0) != 0, (String)"The enchantment level must be greater than 0!");
        this.enchantmentLevel = enchantmentLevel;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        Validate.isTrue((cost > 0 ? 1 : 0) != 0, (String)"The cost must be greater than 0!");
        this.cost = cost;
    }
}

