/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.collect.ImmutableMap;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Target(value={ElementType.CONSTRUCTOR, ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Warning {
    public boolean value() default false;

    public String reason() default "";

    public static enum WarningState {
        ON,
        OFF,
        DEFAULT;

        private static final Map<String, WarningState> values;

        public boolean printFor(@Nullable Warning warning) {
            if (this == DEFAULT) {
                return warning == null || warning.value();
            }
            return this == ON;
        }

        @NotNull
        public static WarningState value(@Nullable String value) {
            if (value == null) {
                return DEFAULT;
            }
            WarningState state = values.get(value.toLowerCase(Locale.ROOT));
            if (state == null) {
                return DEFAULT;
            }
            return state;
        }

        static {
            values = ImmutableMap.builder().put((Object)"off", (Object)OFF).put((Object)"false", (Object)OFF).put((Object)"f", (Object)OFF).put((Object)"no", (Object)OFF).put((Object)"n", (Object)OFF).put((Object)"on", (Object)ON).put((Object)"true", (Object)ON).put((Object)"t", (Object)ON).put((Object)"yes", (Object)ON).put((Object)"y", (Object)ON).put((Object)"", (Object)DEFAULT).put((Object)"d", (Object)DEFAULT).put((Object)"default", (Object)DEFAULT).build();
        }
    }
}

