/*
 * Decompiled with CFR 0.152.
 */
package com.masterok;

import java.io.File;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class BanService {
    private final JavaPlugin plugin;
    private final File file;
    private final YamlConfiguration yml;

    public BanService(JavaPlugin plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "bans.yml");
        this.yml = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public boolean isBanned(UUID uuid) {
        long until = this.yml.getLong("bans." + String.valueOf(uuid) + ".until", 0L);
        if (until == 0L) {
            return this.yml.contains("bans." + String.valueOf(uuid));
        }
        return System.currentTimeMillis() < until;
    }

    public String banReason(UUID uuid) {
        return this.yml.getString("bans." + String.valueOf(uuid) + ".reason", "Bingo-ban");
    }

    public void ban(OfflinePlayer p, long seconds, String reason) {
        long until = 0L;
        if (seconds > 0L) {
            until = System.currentTimeMillis() + seconds * 1000L;
        }
        this.yml.set("bans." + String.valueOf(p.getUniqueId()) + ".name", (Object)p.getName());
        this.yml.set("bans." + String.valueOf(p.getUniqueId()) + ".until", (Object)until);
        this.yml.set("bans." + String.valueOf(p.getUniqueId()) + ".reason", (Object)(reason == null ? "Bingo-ban" : reason));
        this.save();
    }

    public void unban(UUID uuid) {
        this.yml.set("bans." + String.valueOf(uuid), null);
        this.save();
    }

    public void save() {
        try {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            this.yml.save(this.file);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c bans.yml: " + e.getMessage());
        }
    }
}

