/*
 * Decompiled with CFR 0.152.
 */
package com.masterok;

import com.masterok.BanService;
import com.masterok.Bingo;
import com.masterok.BingoGame;
import com.masterok.BingoManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public final class BingoCommand
implements CommandExecutor,
TabCompleter {
    private final Bingo plugin;
    private final BingoManager manager;
    private final BanService bans;

    public BingoCommand(Bingo plugin, BingoManager manager, BanService bans) {
        this.plugin = plugin;
        this.manager = manager;
        this.bans = bans;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (args.length == 0) {
            sender.sendMessage("\u00a7e/bingo start <id> [pvpon|pvpoff]");
            sender.sendMessage("\u00a7e/bingo stop <id>, /bingo join <id>, /bingo leave");
            sender.sendMessage("\u00a7e/bingo sb \u00a77(\u0441\u043a\u0440\u044b\u0442\u044c/\u043f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u043a\u043e\u0440\u0431\u043e\u0440\u0434)");
            sender.sendMessage("\u00a7e/bingo ban <nick> [seconds] [reason...], /bingo unban <nick|uuid>");
            return true;
        }
        switch (sub = args[0].toLowerCase(Locale.ROOT)) {
            case "start": {
                if (!sender.hasPermission("bingo.start")) {
                    sender.sendMessage("\u00a7c\u041d\u0435\u0442 \u043f\u0440\u0430\u0432: bingo.start");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /bingo start <id> [pvpon|pvpoff]");
                    return true;
                }
                String id = args[1];
                boolean pvp = false;
                if (args.length >= 3) {
                    String flag = args[2].toLowerCase(Locale.ROOT);
                    if (flag.equals("pvpon")) {
                        pvp = true;
                    } else if (flag.equals("pvpoff")) {
                        pvp = false;
                    } else {
                        sender.sendMessage("\u00a7c\u0422\u0440\u0435\u0442\u0438\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442: pvpon \u0438\u043b\u0438 pvpoff");
                        return true;
                    }
                }
                this.manager.startGame(id, pvp);
                sender.sendMessage("\u00a7a\u0417\u0430\u043f\u0443\u0449\u0435\u043d Bingo: " + id + " (PvP: " + (pvp ? "ON" : "OFF") + ")");
                return true;
            }
            case "stop": {
                if (!sender.hasPermission("bingo.stop")) {
                    sender.sendMessage("\u00a7c\u041d\u0435\u0442 \u043f\u0440\u0430\u0432: bingo.stop");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /bingo stop <id>");
                    return true;
                }
                String id = args[1];
                this.manager.stopGame(id);
                sender.sendMessage("\u00a7a\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d Bingo: " + id);
                return true;
            }
            case "join": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a.");
                    return true;
                }
                Player p = (Player)sender;
                if (args.length < 2) {
                    Optional<BingoGame> any = this.manager.getAnyJoinableGame();
                    if (any.isEmpty()) {
                        p.sendMessage("\u00a7c\u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 Bingo \u0438\u0433\u0440.");
                        return true;
                    }
                    this.manager.join(p, any.get().getId());
                    return true;
                }
                this.manager.join(p, args[1]);
                return true;
            }
            case "leave": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a.");
                    return true;
                }
                Player p = (Player)sender;
                this.manager.sendLeaveClickableConfirm(p);
                return true;
            }
            case "leaveconfirm": {
                if (!(sender instanceof Player)) {
                    return true;
                }
                Player p = (Player)sender;
                this.manager.leaveConfirmed(p);
                return true;
            }
            case "leavecancel": {
                if (!(sender instanceof Player)) {
                    return true;
                }
                Player p = (Player)sender;
                this.manager.leaveCancelled(p);
                return true;
            }
            case "sb": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a.");
                    return true;
                }
                Player p = (Player)sender;
                this.manager.toggleScoreboard(p);
                return true;
            }
            case "ban": {
                if (!sender.hasPermission("bingo.ban")) {
                    sender.sendMessage("\u00a7c\u041d\u0435\u0442 \u043f\u0440\u0430\u0432: bingo.ban");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /bingo ban <nick> [seconds] [reason...]");
                    return true;
                }
                OfflinePlayer t = Bukkit.getOfflinePlayer((String)args[1]);
                long seconds = this.plugin.getConfig().getLong("bans.defaultBanSeconds", 0L);
                int reasonStart = 2;
                if (args.length >= 3) {
                    try {
                        seconds = Long.parseLong(args[2]);
                        reasonStart = 3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                String reason = "Bingo-ban";
                if (args.length > reasonStart) {
                    reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, reasonStart, args.length));
                }
                this.bans.ban(t, seconds, reason);
                sender.sendMessage("\u00a7aBingo-ban \u0432\u044b\u0434\u0430\u043d: " + t.getName() + " (" + String.valueOf(t.getUniqueId()) + ")");
                return true;
            }
            case "unban": {
                UUID uuid;
                if (!sender.hasPermission("bingo.unban")) {
                    sender.sendMessage("\u00a7c\u041d\u0435\u0442 \u043f\u0440\u0430\u0432: bingo.unban");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /bingo unban <nick|uuid>");
                    return true;
                }
                try {
                    uuid = UUID.fromString(args[1]);
                }
                catch (IllegalArgumentException ex) {
                    OfflinePlayer t = Bukkit.getOfflinePlayer((String)args[1]);
                    uuid = t.getUniqueId();
                }
                this.bans.unban(uuid);
                sender.sendMessage("\u00a7aBingo-unban: " + String.valueOf(uuid));
                return true;
            }
        }
        sender.sendMessage("\u00a7e/bingo start|stop|join|leave|sb|ban|unban");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("start", "stop", "join", "leave", "sb", "ban", "unban");
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("stop") || args[0].equalsIgnoreCase("join"))) {
            ArrayList<String> ids = new ArrayList<String>();
            for (BingoGame g : this.manager.getGames()) {
                ids.add(g.getId());
            }
            return ids;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("start")) {
            return Arrays.asList("pvpon", "pvpoff");
        }
        return Collections.emptyList();
    }
}

