/*
 * Decompiled with CFR 0.152.
 */
package com.masterok;

import com.masterok.BanService;
import com.masterok.BingoGame;
import com.masterok.Lang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class BingoManager {
    private final JavaPlugin plugin;
    private final Lang lang;
    private final BanService bans;
    private final Map<String, BingoGame> games = new HashMap<String, BingoGame>();
    private final Map<UUID, String> pendingLeave = new HashMap<UUID, String>();
    private final Map<UUID, String> lastGameOnQuit = new HashMap<UUID, String>();
    private final Set<UUID> scoreboardHidden = new HashSet<UUID>();

    public BingoManager(JavaPlugin plugin, Lang lang, BanService bans) {
        this.plugin = plugin;
        this.lang = lang;
        this.bans = bans;
    }

    public Collection<BingoGame> getGames() {
        return this.games.values();
    }

    public Optional<BingoGame> getGame(String id) {
        return Optional.ofNullable(this.games.get(id.toLowerCase(Locale.ROOT)));
    }

    public Optional<BingoGame> getAnyJoinableGame() {
        return this.games.values().stream().filter(BingoGame::isJoinOpen).findFirst();
    }

    public boolean hasActiveGames() {
        return this.games.values().stream().anyMatch(BingoGame::isRunning);
    }

    public void startGame(String id, boolean pvpEnabled) {
        if (this.games.containsKey(id = id.toLowerCase(Locale.ROOT)) && this.games.get(id).isRunning()) {
            return;
        }
        BingoGame game = new BingoGame(this.plugin, this.lang, this, id, pvpEnabled);
        this.games.put(id, game);
        game.start();
    }

    public void startGame(String id) {
        this.startGame(id, false);
    }

    public void stopGame(String id) {
        BingoGame g = this.games.get(id = id.toLowerCase(Locale.ROOT));
        if (g != null) {
            g.stop(true);
        }
    }

    public void shutdown() {
        for (BingoGame g : new ArrayList<BingoGame>(this.games.values())) {
            g.stop(false);
        }
        this.games.clear();
        this.pendingLeave.clear();
        this.lastGameOnQuit.clear();
        this.scoreboardHidden.clear();
    }

    public boolean isBanned(Player p) {
        return this.bans.isBanned(p.getUniqueId());
    }

    public void join(Player p, String id) {
        if (this.isBanned(p)) {
            p.sendMessage("\u00a7c\u0422\u0435\u0431\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0438\u0433\u0440\u0430\u0442\u044c \u0432 Bingo. \u041f\u0440\u0438\u0447\u0438\u043d\u0430: " + this.bans.banReason(p.getUniqueId()));
            return;
        }
        BingoGame g = this.games.get(id.toLowerCase(Locale.ROOT));
        if (g == null || !g.isRunning()) {
            p.sendMessage("\u00a7c\u0418\u0433\u0440\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430/\u043d\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u0430.");
            return;
        }
        if (!g.isJoinOpen()) {
            p.sendMessage("\u00a7c\u041e\u043a\u043d\u043e \u0432\u0445\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u043e.");
            return;
        }
        g.join(p);
    }

    public Optional<BingoGame> getPlayerGame(UUID uuid) {
        return this.games.values().stream().filter(g -> g.isParticipant(uuid)).findFirst();
    }

    public boolean toggleScoreboard(Player p) {
        UUID u = p.getUniqueId();
        BingoGame g = this.getPlayerGame(u).orElse(null);
        if (g == null) {
            p.sendMessage("\u00a7c\u0422\u044b \u043d\u0435 \u0432 Bingo.");
            return true;
        }
        if (this.scoreboardHidden.contains(u)) {
            this.scoreboardHidden.remove(u);
            g.applyScoreboardFor(p);
            p.sendMessage("\u00a7aBingo \u0441\u043a\u043e\u0440\u0431\u043e\u0440\u0434 \u0432\u043a\u043b\u044e\u0447\u0451\u043d.");
        } else {
            this.scoreboardHidden.add(u);
            g.hideScoreboardFor(p);
            p.sendMessage("\u00a7eBingo \u0441\u043a\u043e\u0440\u0431\u043e\u0440\u0434 \u0441\u043a\u0440\u044b\u0442.");
        }
        return true;
    }

    public boolean isScoreboardHidden(UUID uuid) {
        return this.scoreboardHidden.contains(uuid);
    }

    public void sendLeaveClickableConfirm(Player p) {
        BingoGame g = this.getPlayerGame(p.getUniqueId()).orElse(null);
        if (g == null) {
            p.sendMessage("\u00a7c\u0422\u044b \u043d\u0435 \u0432 Bingo.");
            return;
        }
        this.pendingLeave.put(p.getUniqueId(), g.getId());
        TextComponent header = new TextComponent("\u00a7e\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438 \u0432\u044b\u0445\u043e\u0434 \u0438\u0437 Bingo:\n");
        TextComponent yes = new TextComponent("\u00a7a[\u0412\u042b\u0419\u0422\u0418]");
        yes.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/bingo leaveconfirm"));
        yes.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7a\u041d\u0430\u0436\u043c\u0438, \u0447\u0442\u043e\u0431\u044b \u0432\u044b\u0439\u0442\u0438").create()));
        TextComponent space = new TextComponent("  ");
        TextComponent no = new TextComponent("\u00a7c[\u041e\u0422\u041c\u0415\u041d\u0410]");
        no.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/bingo leavecancel"));
        no.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7c\u041d\u0430\u0436\u043c\u0438, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c").create()));
        p.spigot().sendMessage(new BaseComponent[]{header, yes, space, no});
    }

    public void leaveConfirmed(Player p) {
        String gameId = this.pendingLeave.remove(p.getUniqueId());
        if (gameId == null) {
            p.sendMessage("\u00a77\u041d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f.");
            return;
        }
        this.getGame(gameId).ifPresent(g -> g.leave(p, true));
        p.sendMessage("\u00a7a\u0422\u044b \u0432\u044b\u0448\u0435\u043b \u0438\u0437 Bingo.");
        this.scoreboardHidden.remove(p.getUniqueId());
    }

    public void leaveCancelled(Player p) {
        if (this.pendingLeave.remove(p.getUniqueId()) != null) {
            p.sendMessage("\u00a77\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.");
        } else {
            p.sendMessage("\u00a77\u041d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f.");
        }
    }

    public void onQuitDuringGame(UUID uuid, String gameId) {
        this.lastGameOnQuit.put(uuid, gameId);
    }

    public void onRejoin(Player p) {
        boolean banIf = this.plugin.getConfig().getBoolean("bans.banIfRejoinAfterEnded", true);
        if (!banIf) {
            return;
        }
        UUID u = p.getUniqueId();
        String gameId = this.lastGameOnQuit.get(u);
        if (gameId == null) {
            return;
        }
        BingoGame g = this.games.get(gameId);
        if (g == null || !g.isRunning()) {
            long seconds = this.plugin.getConfig().getLong("bans.defaultBanSeconds", 0L);
            this.bans.ban((OfflinePlayer)p, seconds, "\u0412\u044b\u0445\u043e\u0434 \u0432\u043e \u0432\u0440\u0435\u043c\u044f Bingo + \u0432\u0445\u043e\u0434 \u043f\u043e\u0441\u043b\u0435 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f");
            p.sendMessage("\u00a7c\u0422\u044b \u0432\u044b\u0448\u0435\u043b \u0432\u043e \u0432\u0440\u0435\u043c\u044f Bingo \u0438 \u0432\u0435\u0440\u043d\u0443\u043b\u0441\u044f \u043f\u043e\u0441\u043b\u0435 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u2014 \u0431\u0430\u043d \u043d\u0430 Bingo.");
        }
        this.lastGameOnQuit.remove(u);
    }
}

