/*
 * Decompiled with CFR 0.152.
 */
package com.masterok;

import com.masterok.BingoGame;
import com.masterok.BingoManager;
import java.util.Comparator;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class BossBarService {
    private final JavaPlugin plugin;
    private final BingoManager manager;
    private BossBar joinBar;
    private int taskId = -1;

    public BossBarService(JavaPlugin plugin, BingoManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public void start() {
        FileConfiguration cfg = this.plugin.getConfig();
        if (!cfg.getBoolean("bossbar.joinEnabled", true)) {
            return;
        }
        String title = cfg.getString("bossbar.joinTitle", "\u00a7aBingo \u0437\u0430\u043f\u0443\u0449\u0435\u043d! \u00a7e/bingo join");
        BarColor color = BarColor.valueOf((String)cfg.getString("bossbar.joinColor", "GREEN"));
        BarStyle style = BarStyle.valueOf((String)cfg.getString("bossbar.joinStyle", "SOLID"));
        this.joinBar = Bukkit.createBossBar((String)title, (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
        this.joinBar.setProgress(1.0);
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            double progress;
            BingoGame g = this.manager.getGames().stream().filter(BingoGame::isJoinOpen).min(Comparator.comparingLong(BingoGame::getJoinCloseAtMillis)).orElse(null);
            if (g == null) {
                this.joinBar.removeAll();
                return;
            }
            long leftMs = Math.max(0L, g.getJoinCloseAtMillis() - System.currentTimeMillis());
            long leftSec = leftMs / 1000L;
            long total = g.getJoinWindowSeconds();
            double d = progress = total <= 0L ? 0.0 : (double)leftSec / (double)total;
            if (progress < 0.0) {
                progress = 0.0;
            }
            if (progress > 1.0) {
                progress = 1.0;
            }
            this.joinBar.setTitle("\u00a7aBingo \u043e\u0442\u043a\u0440\u044b\u0442! \u00a7e/bingo join " + g.getId() + " \u00a77(" + BossBarService.formatSeconds((int)leftSec) + ")");
            this.joinBar.setProgress(progress);
            for (Player p : Bukkit.getOnlinePlayers()) {
                boolean inGame = this.manager.getPlayerGame(p.getUniqueId()).isPresent();
                if (!inGame && !this.manager.isBanned(p)) {
                    this.joinBar.addPlayer(p);
                    continue;
                }
                this.joinBar.removePlayer(p);
            }
        }, 1L, 20L);
    }

    public void stop() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
        this.taskId = -1;
        if (this.joinBar != null) {
            this.joinBar.removeAll();
        }
    }

    private static String formatSeconds(int s) {
        int m = s / 60;
        int ss = s % 60;
        return String.format("%02d:%02d", m, ss);
    }
}

