/*
 * Decompiled with CFR 0.152.
 */
package com.masterok;

import com.masterok.BingoManager;
import com.masterok.Difficulty;
import com.masterok.Lang;
import com.masterok.TopHologramService;
import com.masterok.WinsService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public final class BingoGame {
    private final JavaPlugin plugin;
    private final Lang lang;
    private final BingoManager manager;
    private final String id;
    private final boolean pvpEnabled;
    private final Difficulty difficulty;
    private final WinsService wins;
    private final TopHologramService topHolo;
    private boolean running = false;
    private boolean joinOpen = false;
    private World overworld;
    private World nether;
    private World theEnd;
    private String worldName;
    private final Set<UUID> participants = new HashSet<UUID>();
    private final List<Material> bingoItems = new ArrayList<Material>();
    private final Map<UUID, Set<Material>> found = new HashMap<UUID, Set<Material>>();
    private long joinCloseAtMillis = 0L;
    private int joinWindowSeconds = 0;
    private BossBar timeBar;
    private long endAtMillis = 0L;
    private int barTaskId = -1;

    public BingoGame(JavaPlugin plugin, Lang lang, BingoManager manager, String id, boolean pvpEnabled, Difficulty difficulty, WinsService wins, TopHologramService topHolo) {
        this.plugin = plugin;
        this.lang = lang;
        this.manager = manager;
        this.id = id;
        this.pvpEnabled = pvpEnabled;
        this.difficulty = difficulty;
        this.wins = wins;
        this.topHolo = topHolo;
    }

    public String getId() {
        return this.id;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isJoinOpen() {
        return this.joinOpen;
    }

    public long getJoinCloseAtMillis() {
        return this.joinCloseAtMillis;
    }

    public int getJoinWindowSeconds() {
        return this.joinWindowSeconds;
    }

    public World getOverworld() {
        return this.overworld;
    }

    public World getNether() {
        return this.nether;
    }

    public World getTheEnd() {
        return this.theEnd;
    }

    public World getWorld() {
        return this.overworld;
    }

    public boolean isParticipant(UUID u) {
        return this.participants.contains(u);
    }

    public void start() {
        if (this.running) {
            return;
        }
        FileConfiguration cfg = this.plugin.getConfig();
        this.joinWindowSeconds = cfg.getInt("game.joinWindowSeconds", 300);
        int itemsCount = cfg.getInt("game.itemsCount", 5);
        int durationSeconds = switch (this.difficulty) {
            default -> throw new MatchException(null, null);
            case Difficulty.EASY -> cfg.getInt("difficulty.easySeconds", 1800);
            case Difficulty.MEDIUM -> cfg.getInt("difficulty.mediumSeconds", 5400);
            case Difficulty.HARD -> cfg.getInt("difficulty.hardSeconds", 9000);
        };
        int centerX = cfg.getInt("world.centerX", 0);
        int centerZ = cfg.getInt("world.centerZ", 0);
        int overworldBorderSize = cfg.getInt("world.overworldBorderSize", 10000);
        int netherBorderSize = cfg.getInt("world.netherBorderSize", 1250);
        boolean disableLocatorBar = cfg.getBoolean("world.disableLocatorBar", true);
        this.running = true;
        this.joinOpen = true;
        this.endAtMillis = System.currentTimeMillis() + (long)durationSeconds * 1000L;
        this.joinCloseAtMillis = System.currentTimeMillis() + (long)this.joinWindowSeconds * 1000L;
        this.worldName = "bingo_" + this.id + "_" + System.currentTimeMillis();
        this.overworld = WorldCreator.name((String)this.worldName).environment(World.Environment.NORMAL).type(WorldType.NORMAL).seed(ThreadLocalRandom.current().nextLong()).generateStructures(true).createWorld();
        if (this.overworld == null) {
            this.running = false;
            this.joinOpen = false;
            throw new IllegalStateException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043c\u0438\u0440 Bingo: " + this.id);
        }
        this.nether = WorldCreator.name((String)(this.worldName + "_nether")).environment(World.Environment.NETHER).type(WorldType.NORMAL).seed(this.overworld.getSeed()).generateStructures(true).createWorld();
        this.theEnd = WorldCreator.name((String)(this.worldName + "_the_end")).environment(World.Environment.THE_END).type(WorldType.NORMAL).seed(this.overworld.getSeed()).generateStructures(true).createWorld();
        this.overworld.setPVP(this.pvpEnabled);
        if (this.nether != null) {
            this.nether.setPVP(this.pvpEnabled);
        }
        if (this.theEnd != null) {
            this.theEnd.setPVP(this.pvpEnabled);
        }
        if (disableLocatorBar) {
            try {
                this.overworld.setGameRule(GameRule.LOCATOR_BAR, (Object)false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        WorldBorder ob = this.overworld.getWorldBorder();
        ob.setCenter((double)centerX, (double)centerZ);
        ob.setSize((double)overworldBorderSize);
        if (this.nether != null) {
            WorldBorder nb = this.nether.getWorldBorder();
            nb.setCenter((double)centerX, (double)centerZ);
            nb.setSize((double)netherBorderSize);
        }
        if (this.theEnd != null) {
            this.theEnd.getWorldBorder().reset();
        }
        this.bingoItems.clear();
        this.bingoItems.addAll(this.pickMaterials(itemsCount));
        Bukkit.broadcastMessage((String)("\u00a7aBingo [" + this.id + "] \u0437\u0430\u043f\u0443\u0449\u0435\u043d! \u00a7e/bingo join " + this.id + " \u00a77(PvP: " + (this.pvpEnabled ? "ON" : "OFF") + ", " + this.difficulty.name() + ")"));
        this.startTimerBar(durationSeconds);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.running) {
                this.joinOpen = false;
                Bukkit.broadcastMessage((String)("\u00a7eBingo [" + this.id + "]: \u0432\u0445\u043e\u0434 \u0437\u0430\u043a\u0440\u044b\u0442."));
            }
        }, (long)this.joinWindowSeconds * 20L);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.running) {
                Bukkit.broadcastMessage((String)("\u00a7cBingo [" + this.id + "]: \u0432\u0440\u0435\u043c\u044f \u0432\u044b\u0448\u043b\u043e. \u041f\u043e\u0431\u0435\u0434\u0438\u0442\u0435\u043b\u044f \u043d\u0435\u0442."));
                this.stop(true);
            }
        }, (long)durationSeconds * 20L);
    }

    private void startTimerBar(int durationSeconds) {
        if (!this.plugin.getConfig().getBoolean("bossbar.timeEnabled", true)) {
            return;
        }
        BarColor color = BarColor.valueOf((String)this.plugin.getConfig().getString("bossbar.timeColor", "GREEN"));
        BarStyle style = BarStyle.valueOf((String)this.plugin.getConfig().getString("bossbar.timeStyle", "SOLID"));
        this.timeBar = Bukkit.createBossBar((String)("\u00a7aBingo [" + this.id + "] \u00a77\u041e\u0441\u0442\u0430\u043b\u043e\u0441\u044c: " + BingoGame.formatHms(durationSeconds)), (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
        this.timeBar.setProgress(1.0);
        this.barTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            double progress;
            if (!this.running) {
                return;
            }
            long leftMs = Math.max(0L, this.endAtMillis - System.currentTimeMillis());
            long leftSec = leftMs / 1000L;
            double d = progress = durationSeconds <= 0 ? 0.0 : (double)leftSec / (double)durationSeconds;
            if (progress < 0.0) {
                progress = 0.0;
            }
            if (progress > 1.0) {
                progress = 1.0;
            }
            this.timeBar.setTitle("\u00a7aBingo [" + this.id + "] \u00a77\u041e\u0441\u0442\u0430\u043b\u043e\u0441\u044c: " + BingoGame.formatHms((int)leftSec));
            this.timeBar.setProgress(progress);
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (this.participants.contains(p.getUniqueId())) {
                    this.timeBar.addPlayer(p);
                    continue;
                }
                this.timeBar.removePlayer(p);
            }
            if (leftSec <= 0L && this.running) {
                Bukkit.broadcastMessage((String)("\u00a7cBingo [" + this.id + "]: \u0432\u0440\u0435\u043c\u044f \u0432\u044b\u0448\u043b\u043e. \u041f\u043e\u0431\u0435\u0434\u0438\u0442\u0435\u043b\u044f \u043d\u0435\u0442."));
                this.stop(true);
            }
        }, 1L, 20L);
    }

    public void stop(boolean teleportBack) {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.joinOpen = false;
        if (this.barTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.barTaskId);
        }
        this.barTaskId = -1;
        if (this.timeBar != null) {
            this.timeBar.removeAll();
        }
        this.timeBar = null;
        World main = (World)Bukkit.getWorlds().getFirst();
        Location spawn = main.getSpawnLocation();
        if (teleportBack) {
            for (UUID uuid : new HashSet<UUID>(this.participants)) {
                Player p = Bukkit.getPlayer((UUID)uuid);
                if (p == null || !p.isOnline()) continue;
                this.clearBingoInventory(p);
                p.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
                p.teleport(spawn);
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                for (UUID uuid : new HashSet<UUID>(this.participants)) {
                    Player p = Bukkit.getPlayer((UUID)uuid);
                    if (p == null || !p.isOnline()) continue;
                    p.teleport(spawn);
                }
            }, 2L);
        } else {
            for (UUID uuid : new HashSet<UUID>(this.participants)) {
                Player p = Bukkit.getPlayer((UUID)uuid);
                if (p == null || !p.isOnline()) continue;
                this.clearBingoInventory(p);
                p.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
            }
        }
        this.participants.clear();
        this.found.clear();
        this.bingoItems.clear();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.unloadAndDelete(this.overworld);
            this.unloadAndDelete(this.nether);
            this.unloadAndDelete(this.theEnd);
            this.overworld = null;
            this.nether = null;
            this.theEnd = null;
            this.worldName = null;
            this.endAtMillis = 0L;
            this.joinCloseAtMillis = 0L;
            this.joinWindowSeconds = 0;
        }, 5L);
    }

    public void join(Player p) {
        if (!this.running || this.overworld == null) {
            p.sendMessage("\u00a7cBingo \u043d\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d.");
            return;
        }
        FileConfiguration cfg = this.plugin.getConfig();
        long teleportDelayTicks = cfg.getLong("game.teleportDelayTicks", 40L);
        int safeRadius = cfg.getInt("world.safeRadiusOverworld", 450);
        int minDist = cfg.getInt("game.minPlayerDistance", 100);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (!this.running || this.overworld == null) {
                return;
            }
            this.participants.add(p.getUniqueId());
            this.found.computeIfAbsent(p.getUniqueId(), k -> new HashSet());
            this.clearBingoInventory(p);
            p.setFoodLevel(20);
            p.setHealth(Math.min(p.getHealth(), 20.0));
            p.teleport(this.findSpawnLocationForNextPlayer(safeRadius, minDist));
            this.applyScoreboardFor(p);
            p.sendMessage("\u00a7a\u0422\u044b \u0432\u043e\u0448\u0451\u043b \u0432 Bingo [" + this.id + "]. \u0421\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c: " + this.difficulty.name());
        }, teleportDelayTicks);
    }

    public void leave(Player p, boolean teleportBack) {
        if (!this.participants.remove(p.getUniqueId())) {
            return;
        }
        this.found.remove(p.getUniqueId());
        this.clearBingoInventory(p);
        p.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
        if (teleportBack) {
            World main = (World)Bukkit.getWorlds().getFirst();
            p.teleport(main.getSpawnLocation());
        }
        if (this.timeBar != null) {
            this.timeBar.removePlayer(p);
        }
    }

    public void hideScoreboardFor(Player p) {
        p.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
    }

    public void applyScoreboardFor(Player p) {
        if (this.manager.isScoreboardHidden(p.getUniqueId())) {
            this.hideScoreboardFor(p);
            return;
        }
        p.setScoreboard(this.buildBoardFor(p));
    }

    public void onPlayerGotItem(Player p, Material mat) {
        if (!this.running) {
            return;
        }
        if (!this.participants.contains(p.getUniqueId())) {
            return;
        }
        World pw = p.getWorld();
        if (pw != this.overworld && pw != this.nether && pw != this.theEnd) {
            return;
        }
        if (!this.bingoItems.contains(mat)) {
            return;
        }
        Set set = this.found.computeIfAbsent(p.getUniqueId(), k -> new HashSet());
        if (!set.add(mat)) {
            return;
        }
        Bukkit.broadcastMessage((String)("\u00a7bBingo [" + this.id + "]: \u00a7e" + p.getName() + " \u00a7b\u043d\u0430\u0448\u0451\u043b \u00a7f" + this.lang.name(mat) + " \u00a77(" + set.size() + "/" + this.bingoItems.size() + ")"));
        this.applyScoreboardFor(p);
        if (set.size() >= this.bingoItems.size()) {
            Bukkit.broadcastMessage((String)("\u00a76Bingo [" + this.id + "]: \u043f\u043e\u0431\u0435\u0434\u0438\u0442\u0435\u043b\u044c " + p.getName() + "!"));
            this.wins.addWin((OfflinePlayer)p);
            if (this.plugin.getConfig().getBoolean("topHologram.enabled", true)) {
                this.topHolo.updateText();
            }
            this.stop(true);
        }
    }

    private void clearBingoInventory(Player p) {
        p.closeInventory();
        p.getInventory().clear();
        p.getInventory().setArmorContents(null);
        p.getInventory().setItemInOffHand(null);
        p.getEnderChest().clear();
        p.setFireTicks(0);
        p.setGlowing(false);
        p.setAbsorptionAmount(0.0);
    }

    private Scoreboard buildBoardFor(Player p) {
        ScoreboardManager sm = Bukkit.getScoreboardManager();
        Scoreboard sb = sm != null ? sm.getNewScoreboard() : Bukkit.getScoreboardManager().getMainScoreboard();
        Objective obj = sb.registerNewObjective("bingo", "dummy", "\u00a7aBingo [" + this.id + "]");
        obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        Set got = this.found.computeIfAbsent(p.getUniqueId(), k -> new HashSet());
        int line = 15;
        obj.getScore("\u00a7e\u041f\u0440\u0435\u0434\u043c\u0435\u0442\u044b (" + this.difficulty.name() + "):").setScore(line--);
        for (Material m : this.bingoItems) {
            boolean done = got.contains(m);
            String prefix = done ? "\u00a7a\u2714 " : "\u00a7c\u2718 ";
            Object text = prefix + this.lang.name(m);
            if (((String)text).length() > 40) {
                text = ((String)text).substring(0, 40);
            }
            obj.getScore((String)text).setScore(line--);
        }
        obj.getScore("\u00a77\u041e\u0441\u0442\u0430\u043b\u043e\u0441\u044c: " + (this.bingoItems.size() - got.size())).setScore(line--);
        return sb;
    }

    private List<Material> pickMaterials(int count) {
        ArrayList<Material> pool = new ArrayList<Material>();
        for (Material m : Material.values()) {
            String n;
            if (!m.isItem() || m.isAir() || (n = m.name()).contains("SPAWN_EGG") || n.contains("COMMAND_BLOCK") || n.contains("STRUCTURE_") || n.contains("JIGSAW") || n.contains("SPAWNER") || n.contains("PORTAL") || n.startsWith("INFESTED_") || m == Material.BEDROCK || m == Material.BARRIER || m == Material.LIGHT || this.difficulty == Difficulty.MEDIUM && (n.contains("END") || n.contains("CHORUS") || n.contains("SHULKER") || n.contains("DRAGON")) || this.difficulty == Difficulty.EASY && (n.startsWith("NETHER_") || n.contains("NETHER") || n.contains("END") || n.contains("CHORUS") || n.contains("SHULKER") || n.contains("DRAGON") || n.contains("ELYTRA") || n.contains("BEACON") || n.contains("NETHERITE") || n.contains("WITHER") || n.contains("SKULL") || n.contains("STAR") || n.contains("TRIDENT") || n.contains("HEART_OF_THE_SEA") || n.contains("CONDUIT") || n.contains("TOTEM_OF_UNDYING") || n.contains("ANCIENT_DEBRIS") || n.contains("TNT") || n.contains("RESPAWN_ANCHOR") || n.contains("DIAMOND") || n.contains("ENCHANT"))) continue;
            pool.add(m);
        }
        Collections.shuffle(pool);
        if (count < 1) {
            count = 1;
        }
        if (count > pool.size()) {
            count = pool.size();
        }
        return pool.subList(0, count);
    }

    private Location findSpawnLocationForNextPlayer(int safeRadius, int minDist) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        int min = -safeRadius;
        int max = safeRadius;
        for (int attempt = 0; attempt < 120; ++attempt) {
            int x = r.nextInt(min, max + 1);
            int z = r.nextInt(min, max + 1);
            Location base = new Location(this.overworld, (double)x + 0.5, 0.0, (double)z + 0.5);
            base.setY((double)(this.overworld.getHighestBlockYAt(x, z) + 1));
            if (!this.isFarEnough(base, minDist)) continue;
            base.setYaw(r.nextFloat() * 360.0f);
            base.setPitch(0.0f);
            return base;
        }
        Location spawn = this.overworld.getSpawnLocation().clone();
        spawn.setY((double)(this.overworld.getHighestBlockYAt(spawn) + 1));
        return spawn;
    }

    private boolean isFarEnough(Location loc, double minDist) {
        for (UUID uuid : this.participants) {
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p == null || !p.isOnline() || p.getWorld() != this.overworld || !(p.getLocation().distance(loc) < minDist)) continue;
            return false;
        }
        return true;
    }

    private void unloadAndDelete(World w) {
        if (w == null) {
            return;
        }
        String name = w.getName();
        Bukkit.unloadWorld((World)w, (boolean)false);
        File folder = new File(Bukkit.getWorldContainer(), name);
        this.deleteFolder(folder);
    }

    private void deleteFolder(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                this.deleteFolder(f);
            }
        }
        file.delete();
    }

    private static String formatHms(int s) {
        int h = s / 3600;
        int m = s % 3600 / 60;
        int ss = s % 60;
        if (h > 0) {
            return String.format("%d:%02d:%02d", h, m, ss);
        }
        return String.format("%02d:%02d", m, ss);
    }
}

