/*
 * Decompiled with CFR 0.152.
 */
package com.masterok;

import com.masterok.BingoManager;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public final class BingoListener
implements Listener {
    private final BingoManager manager;
    private final Map<UUID, Long> teleportGuardUntil = new ConcurrentHashMap<UUID, Long>();

    public BingoListener(BingoManager manager) {
        this.manager = manager;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        this.manager.onRejoin(e.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        this.teleportGuardUntil.remove(p.getUniqueId());
        this.manager.getPlayerGame(p.getUniqueId()).ifPresent(g -> this.manager.onQuitDuringGame(p.getUniqueId(), g.getId()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPortal(PlayerPortalEvent e) {
        Player p = e.getPlayer();
        this.manager.getPlayerGame(p.getUniqueId()).ifPresent(g -> {
            World from = p.getWorld();
            World over = g.getOverworld();
            World nether = g.getNether();
            World end = g.getTheEnd();
            if (over == null) {
                return;
            }
            if (e.getCause() == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL && nether != null) {
                if (from == over) {
                    Location base = nether.getSpawnLocation().clone();
                    Location fr = e.getFrom();
                    if (fr != null) {
                        base.setX(fr.getX() / 8.0);
                        base.setZ(fr.getZ() / 8.0);
                        base.setY(Math.min(120.0, Math.max(20.0, fr.getY())));
                    }
                    e.setTo(BingoListener.randomOffsetSafe(base, nether, 10, 20));
                    e.setCanCreatePortal(true);
                    return;
                }
                if (from == nether) {
                    Location base = over.getSpawnLocation().clone();
                    Location fr = e.getFrom();
                    if (fr != null) {
                        base.setX(fr.getX() * 8.0);
                        base.setZ(fr.getZ() * 8.0);
                        base.setY(Math.min(300.0, Math.max(70.0, fr.getY())));
                    }
                    e.setTo(BingoListener.randomOffsetSafe(base, over, 10, 20));
                    e.setCanCreatePortal(true);
                    return;
                }
            }
            if (e.getCause() == PlayerTeleportEvent.TeleportCause.END_PORTAL && end != null) {
                if (from == over) {
                    e.setTo(end.getSpawnLocation());
                    e.setCanCreatePortal(true);
                    return;
                }
                if (from == end) {
                    e.setTo(BingoListener.randomOffsetSafe(over.getSpawnLocation().clone(), over, 10, 20));
                    e.setCanCreatePortal(true);
                }
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent e) {
        Player p = e.getPlayer();
        UUID u = p.getUniqueId();
        long now = System.currentTimeMillis();
        Long guard = this.teleportGuardUntil.get(u);
        if (guard != null && guard > now) {
            return;
        }
        this.manager.getPlayerGame(u).ifPresent(g -> {
            World first;
            World over = g.getOverworld();
            World nether = g.getNether();
            World end = g.getTheEnd();
            if (over == null) {
                return;
            }
            Location to = e.getTo();
            if (to == null || to.getWorld() == null) {
                return;
            }
            World toW = to.getWorld();
            World fromW = p.getWorld();
            World world = first = Bukkit.getWorlds().isEmpty() ? null : (World)Bukkit.getWorlds().getFirst();
            if (end != null && fromW == end && first != null && toW.equals((Object)first)) {
                this.teleportGuardUntil.put(u, now + 1500L);
                e.setTo(BingoListener.randomOffsetSafe(over.getSpawnLocation().clone(), over, 10, 20));
            }
            if (fromW == over && toW == over && BingoListener.isNear(to, over.getSpawnLocation(), 3.5)) {
                this.teleportGuardUntil.put(u, now + 1500L);
                e.setTo(BingoListener.randomOffsetSafe(to.clone(), over, 10, 20));
            }
            if (nether != null && fromW == nether && toW == nether && BingoListener.isNear(to, nether.getSpawnLocation(), 3.5)) {
                this.teleportGuardUntil.put(u, now + 1500L);
                e.setTo(BingoListener.randomOffsetSafe(to.clone(), nether, 10, 20));
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRespawn(PlayerRespawnEvent e) {
        Player p = e.getPlayer();
        this.manager.getPlayerGame(p.getUniqueId()).ifPresent(g -> {
            Location current;
            World over = g.getOverworld();
            World end = g.getTheEnd();
            if (over == null || end == null) {
                return;
            }
            Location location = current = p.getWorld() != null ? p.getWorld().getSpawnLocation() : null;
            if (p.getWorld() == end || e.getRespawnLocation() != null && e.getRespawnLocation().getWorld() != null && e.getRespawnLocation().getWorld().equals(Bukkit.getWorlds().getFirst())) {
                e.setRespawnLocation(BingoListener.randomOffsetSafe(over.getSpawnLocation().clone(), over, 10, 20));
            }
        });
    }

    private static boolean isNear(Location a, Location b, double r) {
        double dz;
        double dy;
        if (a == null || b == null) {
            return false;
        }
        if (a.getWorld() != b.getWorld()) {
            return false;
        }
        double dx = a.getX() - b.getX();
        return dx * dx + (dy = a.getY() - b.getY()) * dy + (dz = a.getZ() - b.getZ()) * dz <= r * r;
    }

    private static Location randomOffsetSafe(Location base, World targetWorld, int min, int max) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        for (int attempt = 0; attempt < 60; ++attempt) {
            int z;
            int y;
            double angle = r.nextDouble(0.0, Math.PI * 2);
            double dist = r.nextDouble(min, max + 1);
            int x = (int)Math.floor(base.getX() + Math.cos(angle) * dist);
            Location loc = new Location(targetWorld, (double)x + 0.5, (double)(y = targetWorld.getHighestBlockYAt(x, z = (int)Math.floor(base.getZ() + Math.sin(angle) * dist)) + 1), (double)z + 0.5, base.getYaw(), base.getPitch());
            if (!loc.getBlock().isPassable() || !loc.clone().add(0.0, 1.0, 0.0).getBlock().isPassable()) continue;
            return loc;
        }
        int x = base.getBlockX();
        int z = base.getBlockZ();
        int y = targetWorld.getHighestBlockYAt(x, z) + 1;
        return new Location(targetWorld, (double)x + 0.5, (double)y, (double)z + 0.5, base.getYaw(), base.getPitch());
    }

    @EventHandler
    public void onPickup(EntityPickupItemEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player p = (Player)livingEntity;
        this.manager.getPlayerGame(p.getUniqueId()).ifPresent(g -> g.onPlayerGotItem(p, e.getItem().getItemStack().getType()));
    }

    @EventHandler
    public void onCraft(CraftItemEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        this.manager.getPlayerGame(p.getUniqueId()).ifPresent(g -> g.onPlayerGotItem(p, e.getRecipe().getResult().getType()));
    }

    @EventHandler
    public void onPvp(EntityDamageByEntityEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        Entity entity2 = e.getDamager();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player damager = (Player)entity2;
        this.manager.getPlayerGame(victim.getUniqueId()).ifPresent(g -> {
            World vw = victim.getWorld();
            World dw = damager.getWorld();
            if (vw != null && vw == dw && (vw == g.getOverworld() || vw == g.getNether() || vw == g.getTheEnd())) {
                e.setCancelled(true);
            }
        });
    }
}

