/*
 * Decompiled with CFR 0.152.
 */
package com.masterok;

import java.util.ArrayDeque;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ChunkPregenService {
    private final JavaPlugin plugin;

    public ChunkPregenService(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void startForWorld(World world) {
        int radiusBlocks;
        if (world == null) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("chunkPregen.enabled", true)) {
            return;
        }
        int chunksPerTick = Math.max(1, this.plugin.getConfig().getInt("chunkPregen.chunksPerTick", 3));
        if (this.plugin.getConfig().getBoolean("chunkPregen.useBorderRadius", true)) {
            WorldBorder wb = world.getWorldBorder();
            radiusBlocks = (int)Math.floor(wb.getSize() / 2.0);
        } else {
            radiusBlocks = 2000;
        }
        int radiusChunks = Math.max(1, radiusBlocks / 16);
        int centerX = (int)Math.floor(world.getWorldBorder().getCenter().getX()) >> 4;
        int centerZ = (int)Math.floor(world.getWorldBorder().getCenter().getZ()) >> 4;
        ArrayDeque<long[]> queue = new ArrayDeque<long[]>();
        for (int x = -radiusChunks; x <= radiusChunks; ++x) {
            for (int z = -radiusChunks; z <= radiusChunks; ++z) {
                queue.add(new long[]{centerX + x, centerZ + z});
            }
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, task -> {
            if (!world.isChunkGenerated(centerX, centerZ) && !world.isChunkLoaded(centerX, centerZ)) {
                world.getChunkAt(centerX, centerZ);
            }
            for (int i = 0; i < chunksPerTick; ++i) {
                long[] c = (long[])queue.poll();
                if (c == null) {
                    task.cancel();
                    return;
                }
                int cx = (int)c[0];
                int cz = (int)c[1];
                world.getChunkAt(cx, cz);
            }
        }, 1L, 1L);
    }
}

