/*
 * Decompiled with CFR 0.152.
 */
package com.masterok;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.plugin.java.JavaPlugin;

public final class Lang {
    private final Map<String, String> ru = new HashMap<String, String>();

    public Lang(JavaPlugin plugin) {
        this.load(plugin);
    }

    public String name(Material material) {
        String key = material.getTranslationKey();
        return this.ru.getOrDefault(key, Lang.fallbackFromKey(key));
    }

    private void load(JavaPlugin plugin) {
        this.ru.clear();
        String path = plugin.getConfig().getString("translations.bundledPath", "lang/ru_ru.json");
        try (InputStream is = plugin.getResource(path);){
            if (is == null) {
                plugin.getLogger().warning("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d resource: " + path + " (\u043f\u0440\u043e\u0432\u0435\u0440\u044c src/main/resources/lang/ru_ru.json)");
                return;
            }
            String json = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            Lang.parseFlatJsonObject(json, this.ru);
            plugin.getLogger().info("RU \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u044b \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b: " + this.ru.size());
        }
        catch (Exception e) {
            plugin.getLogger().warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 ru_ru.json: " + e.getMessage());
        }
    }

    private static void parseFlatJsonObject(String raw, Map<String, String> out) {
        String json = raw.trim();
        if (json.startsWith("{")) {
            json = json.substring(1);
        }
        if (json.endsWith("}")) {
            json = json.substring(0, json.length() - 1);
        }
        List<String> pairs = Lang.splitTopLevel(json);
        for (String p : pairs) {
            int colon = Lang.indexOfTopLevelColon(p);
            if (colon < 0) continue;
            String k = Lang.unquote(p.substring(0, colon).trim());
            String v = Lang.unquote(p.substring(colon + 1).trim());
            if (k.isEmpty() || v.isEmpty()) continue;
            out.put(k, v);
        }
    }

    private static String fallbackFromKey(String key) {
        String base = key.replace("block.minecraft.", "").replace("item.minecraft.", "").replace('_', ' ').trim();
        if (base.isEmpty()) {
            return key;
        }
        return Character.toUpperCase(base.charAt(0)) + base.substring(1);
    }

    private static String unquote(String s) {
        if ((s = s.trim()).startsWith("\"") && s.endsWith("\"") && s.length() >= 2) {
            s = s.substring(1, s.length() - 1);
        }
        return s.replace("\\\"", "\"").replace("\\n", "\n").replace("\\\\", "\\");
    }

    private static int indexOfTopLevelColon(String s) {
        boolean inQuotes = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"' && (i == 0 || s.charAt(i - 1) != '\\')) {
                boolean bl = inQuotes = !inQuotes;
            }
            if (inQuotes || c != ':') continue;
            return i;
        }
        return -1;
    }

    private static List<String> splitTopLevel(String s) {
        ArrayList<String> out = new ArrayList<String>();
        boolean inQuotes = false;
        int start = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"' && (i == 0 || s.charAt(i - 1) != '\\')) {
                boolean bl = inQuotes = !inQuotes;
            }
            if (inQuotes || c != ',') continue;
            out.add(s.substring(start, i).trim());
            start = i + 1;
        }
        String last = s.substring(start).trim();
        if (!last.isEmpty()) {
            out.add(last);
        }
        return out;
    }
}

