/*
 * Decompiled with CFR 0.152.
 */
package com.masterok;

import com.masterok.WinsService;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.java.JavaPlugin;

public final class TopHologramService {
    private final JavaPlugin plugin;
    private final WinsService wins;
    private final File file;
    private final YamlConfiguration yml;
    private final List<ArmorStand> stands = new ArrayList<ArmorStand>();

    public TopHologramService(JavaPlugin plugin, WinsService wins) {
        this.plugin = plugin;
        this.wins = wins;
        this.file = new File(plugin.getDataFolder(), "top-hologram.yml");
        this.yml = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public boolean hasLocation() {
        return this.yml.contains("loc.world");
    }

    public Location getLocation() {
        World w;
        String wName = this.yml.getString("loc.world");
        World world = w = wName == null ? null : Bukkit.getWorld((String)wName);
        if (w == null) {
            return null;
        }
        double x = this.yml.getDouble("loc.x");
        double y = this.yml.getDouble("loc.y");
        double z = this.yml.getDouble("loc.z");
        float yaw = (float)this.yml.getDouble("loc.yaw");
        float pitch = (float)this.yml.getDouble("loc.pitch");
        return new Location(w, x, y, z, yaw, pitch);
    }

    public void setLocation(Location loc) {
        this.yml.set("loc.world", (Object)loc.getWorld().getName());
        this.yml.set("loc.x", (Object)loc.getX());
        this.yml.set("loc.y", (Object)loc.getY());
        this.yml.set("loc.z", (Object)loc.getZ());
        this.yml.set("loc.yaw", (Object)Float.valueOf(loc.getYaw()));
        this.yml.set("loc.pitch", (Object)Float.valueOf(loc.getPitch()));
        this.save();
        this.respawn();
    }

    public void remove() {
        this.yml.set("loc", null);
        this.save();
        this.despawn();
    }

    public void respawn() {
        this.despawn();
        Location base = this.getLocation();
        if (base == null) {
            return;
        }
        double spacing = this.plugin.getConfig().getDouble("topHologram.lineSpacing", 0.27);
        List<String> lines = this.buildLines();
        Location cur = base.clone();
        for (String line : lines) {
            ArmorStand as = (ArmorStand)base.getWorld().spawnEntity(cur, EntityType.ARMOR_STAND);
            as.setVisible(false);
            as.setGravity(false);
            as.setMarker(true);
            as.setCustomName(line);
            as.setCustomNameVisible(true);
            as.setInvulnerable(true);
            as.setPersistent(true);
            this.stands.add(as);
            cur = cur.clone().add(0.0, -spacing, 0.0);
        }
    }

    public void updateText() {
        if (this.stands.isEmpty()) {
            if (this.hasLocation()) {
                this.respawn();
            }
            return;
        }
        List<String> lines = this.buildLines();
        for (int i = 0; i < this.stands.size() && i < lines.size(); ++i) {
            ArmorStand as = this.stands.get(i);
            if (!as.isValid()) continue;
            as.setCustomName(lines.get(i));
        }
    }

    private List<String> buildLines() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("\u00a76\u00a7l\u0422\u043e\u043f Bingo (\u043f\u043e\u0431\u0435\u0434\u044b)");
        List<Map.Entry<UUID, Integer>> top = this.wins.top(5);
        if (top.isEmpty()) {
            lines.add("\u00a77\u041f\u043e\u043a\u0430 \u043f\u0443\u0441\u0442\u043e");
            return lines;
        }
        int pos = 1;
        for (Map.Entry<UUID, Integer> e : top) {
            lines.add("\u00a7e" + pos + ". \u00a7f" + this.wins.name(e.getKey()) + " \u00a77- \u00a7a" + String.valueOf(e.getValue()));
            ++pos;
        }
        return lines;
    }

    public void despawn() {
        for (ArmorStand as : new ArrayList<ArmorStand>(this.stands)) {
            try {
                as.remove();
            }
            catch (Throwable throwable) {}
        }
        this.stands.clear();
    }

    public void save() {
        try {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            this.yml.save(this.file);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c top-hologram.yml: " + e.getMessage());
        }
    }
}

