/*
 * Decompiled with CFR 0.152.
 */
package com.masterok;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class WinsService {
    private final JavaPlugin plugin;
    private final File file;
    private final YamlConfiguration yml;

    public WinsService(JavaPlugin plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "wins.yml");
        this.yml = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public int getWins(UUID uuid) {
        return this.yml.getInt("wins." + String.valueOf(uuid), 0);
    }

    public void addWin(OfflinePlayer p) {
        UUID u = p.getUniqueId();
        int w = this.getWins(u) + 1;
        this.yml.set("wins." + String.valueOf(u), (Object)w);
        this.yml.set("names." + String.valueOf(u), (Object)p.getName());
        this.save();
    }

    public List<Map.Entry<UUID, Integer>> top(int limit) {
        ConfigurationSection sec = this.yml.getConfigurationSection("wins");
        if (sec == null) {
            return List.of();
        }
        HashMap<UUID, Integer> map = new HashMap<UUID, Integer>();
        for (String k : sec.getKeys(false)) {
            try {
                UUID u = UUID.fromString(k);
                map.put(u, sec.getInt(k, 0));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return map.entrySet().stream().sorted((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue())).limit(limit).collect(Collectors.toList());
    }

    public String name(UUID uuid) {
        String n = this.yml.getString("names." + String.valueOf(uuid));
        if (n != null && !n.isBlank()) {
            return n;
        }
        OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)uuid);
        return op.getName() != null ? op.getName() : uuid.toString();
    }

    public void save() {
        try {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            this.yml.save(this.file);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c wins.yml: " + e.getMessage());
        }
    }
}

