/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.inffriend.commands;

import com.masterok.inffriend.InfFriendPlugin;
import com.masterok.inffriend.friend.FriendService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class FriendMsgCommand
implements CommandExecutor,
TabCompleter {
    private final InfFriendPlugin plugin;
    private final FriendService friends;

    public FriendMsgCommand(InfFriendPlugin plugin, FriendService friends) {
        this.plugin = plugin;
        this.friends = friends;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.cfg().msg("only-players"));
            return true;
        }
        Player p = (Player)sender;
        if (!this.plugin.cfg().privateMessagesEnabled()) {
            p.sendMessage(this.plugin.cfg().msg("feature-disabled"));
            return true;
        }
        if (args.length < 2) {
            p.sendMessage(this.plugin.cfg().color("&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /fmsg <\u043d\u0438\u043a> <\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435>"));
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            p.sendMessage(this.plugin.cfg().msg("player-offline"));
            return true;
        }
        if (!this.friends.areFriends(p.getUniqueId(), target.getUniqueId())) {
            p.sendMessage(this.plugin.cfg().msg("not-friends"));
            return true;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            if (i > 1) {
                sb.append(' ');
            }
            sb.append(args[i]);
        }
        String message = sb.toString();
        p.sendMessage(this.plugin.cfg().msg("msg-format-to").replace("{player}", target.getName()).replace("{message}", message));
        target.sendMessage(this.plugin.cfg().msg("msg-format-from").replace("{player}", p.getName()).replace("{message}", message));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player p = (Player)sender;
        if (!this.plugin.cfg().privateMessagesEnabled()) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            ArrayList<String> names = new ArrayList<String>();
            Set<UUID> friendIds = this.friends.friendsOf(p.getUniqueId());
            for (UUID id : friendIds) {
                OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)id);
                if (!op.isOnline() || op.getName() == null) continue;
                names.add(op.getName());
            }
            Collections.sort(names);
            return this.filterStartsWith(names, args[0]);
        }
        return Collections.emptyList();
    }

    private List<String> filterStartsWith(List<String> list, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        String p = prefix.toLowerCase();
        ArrayList<String> out = new ArrayList<String>();
        for (String s : list) {
            if (s == null || !s.toLowerCase().startsWith(p)) continue;
            out.add(s);
        }
        return out;
    }
}

