/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.inffriend.gui;

import com.masterok.inffriend.InfFriendPlugin;
import com.masterok.inffriend.compat.ItemFactory;
import com.masterok.inffriend.gui.MenuKeys;
import com.masterok.inffriend.util.Text;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;

public final class FriendMenu {
    private static final SimpleDateFormat DF = new SimpleDateFormat("dd.MM.yyyy HH:mm");

    private FriendMenu() {
    }

    public static void openMain(InfFriendPlugin plugin, Player viewer, int page) {
        int base;
        int maxPage;
        int size = plugin.cfg().guiSize();
        if (size < 27) {
            size = 54;
        }
        ItemFactory items = new ItemFactory(plugin);
        Inventory inv = Bukkit.createInventory((InventoryHolder)viewer, (int)size, (String)plugin.cfg().guiTitle());
        int rows = size / 9;
        int friendAreaSize = (rows - 1) * 9;
        ArrayList<UUID> friends = new ArrayList<UUID>(plugin.friends().friendsOf(viewer.getUniqueId()));
        friends.sort(new Comparator<UUID>(){

            @Override
            public int compare(UUID a, UUID b) {
                OfflinePlayer oa = Bukkit.getOfflinePlayer((UUID)a);
                OfflinePlayer ob = Bukkit.getOfflinePlayer((UUID)b);
                String na = oa.getName() == null ? "" : oa.getName().toLowerCase();
                String nb = ob.getName() == null ? "" : ob.getName().toLowerCase();
                return na.compareTo(nb);
            }
        });
        int total = friends.size();
        int online = 0;
        for (UUID id : friends) {
            if (!Bukkit.getOfflinePlayer((UUID)id).isOnline()) continue;
            ++online;
        }
        int offline = total - online;
        int perPage = friendAreaSize;
        int n = maxPage = perPage <= 0 ? 0 : (int)Math.max(0.0, Math.ceil((double)total / (double)perPage) - 1.0);
        if (page < 0) {
            page = 0;
        }
        if (page > maxPage) {
            page = maxPage;
        }
        int start = page * perPage;
        int end = Math.min(start + perPage, total);
        int slot = 0;
        for (int i = start; i < end; ++i) {
            Player pl;
            UUID friendId = (UUID)friends.get(i);
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)friendId);
            ItemStack item = FriendMenu.head(op);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(Text.c("&f" + (op.getName() == null ? "Unknown" : op.getName())));
            ArrayList<String> lore = new ArrayList<String>();
            boolean isOnline = op.isOnline();
            lore.add(plugin.cfg().guiText(isOnline ? "online" : "offline"));
            long lastSeen = plugin.friends().lastSeen(friendId);
            if (!isOnline && lastSeen > 0L) {
                lore.add(plugin.cfg().guiText("lastseen").replace("{time}", DF.format(new Date(lastSeen))));
            }
            if (isOnline && plugin.cfg().coordsEnabled()) {
                pl = op.getPlayer();
                lore.add(plugin.cfg().guiText("coords").replace("{x}", String.valueOf(pl.getLocation().getBlockX())).replace("{y}", String.valueOf(pl.getLocation().getBlockY())).replace("{z}", String.valueOf(pl.getLocation().getBlockZ())));
            }
            if (isOnline && plugin.cfg().healthEnabled()) {
                pl = op.getPlayer();
                double hp = pl.getHealth();
                double max = pl.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
                lore.add(plugin.cfg().guiText("hp").replace("{hp}", String.valueOf((int)Math.ceil(hp))).replace("{max}", String.valueOf((int)Math.ceil(max))));
            }
            meta.setLore(lore);
            meta.getPersistentDataContainer().set(MenuKeys.keyFriendUuid(plugin), PersistentDataType.STRING, (Object)friendId.toString());
            item.setItemMeta(meta);
            inv.setItem(slot++, item);
        }
        for (int i = base = (rows - 1) * 9; i < base + 9; ++i) {
            inv.setItem(i, FriendMenu.glass(Material.GRAY_STAINED_GLASS_PANE, " "));
        }
        inv.setItem(base + 0, FriendMenu.actionBtn(plugin, items, "close", "&c\u238b \u0417\u0430\u043a\u0440\u044b\u0442\u044c", "CLOSE", page, null));
        inv.setItem(base + 1, FriendMenu.actionBtn(plugin, items, "refresh", "&a\u27f2 \u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c", "REFRESH", page, null));
        if (page > 0) {
            inv.setItem(base + 3, FriendMenu.actionBtn(plugin, items, "prev", "&e\u25c0 \u041d\u0430\u0437\u0430\u0434", "PREV", page, null));
        }
        if (page < maxPage) {
            inv.setItem(base + 5, FriendMenu.actionBtn(plugin, items, "next", "&e\u0412\u043f\u0435\u0440\u0451\u0434 \u25b6", "NEXT", page, null));
        }
        ItemStack stats = items.icon("stats", Material.PAPER);
        items.applyName(stats, "&b\ud83d\udcca \u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430");
        ItemMeta sm = stats.getItemMeta();
        ArrayList<String> sl = new ArrayList<String>();
        sl.add(Text.c("&7\u0412\u0441\u0435\u0433\u043e: &f" + total));
        sl.add(Text.c("&7\u041e\u043d\u043b\u0430\u0439\u043d: &a" + online));
        sl.add(Text.c("&7\u041e\u0444\u0444\u043b\u0430\u0439\u043d: &c" + offline));
        sl.add(Text.c("&7\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430: &f" + (page + 1) + "/" + (maxPage + 1)));
        sm.setLore(sl);
        stats.setItemMeta(sm);
        inv.setItem(base + 8, stats);
        viewer.openInventory(inv);
    }

    public static void openActions(InfFriendPlugin plugin, Player viewer, UUID friendId, int returnPage) {
        ItemFactory items = new ItemFactory(plugin);
        OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)friendId);
        String title = plugin.cfg().guiText("actions-title").replace("{player}", op.getName() == null ? "Unknown" : op.getName());
        Inventory inv = Bukkit.createInventory((InventoryHolder)viewer, (int)27, (String)title);
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, FriendMenu.glass(Material.BLACK_STAINED_GLASS_PANE, " "));
        }
        ItemStack head = FriendMenu.head(op);
        ItemMeta hm = head.getItemMeta();
        hm.setDisplayName(Text.c("&f" + (op.getName() == null ? "Unknown" : op.getName())));
        head.setItemMeta(hm);
        inv.setItem(13, head);
        if (plugin.cfg().teleportEnabled()) {
            inv.setItem(11, FriendMenu.actionBtn(plugin, items, "action-teleport", plugin.cfg().guiText("btn-teleport"), "TP", returnPage, friendId));
        }
        if (plugin.cfg().privateMessagesEnabled()) {
            inv.setItem(15, FriendMenu.actionBtn(plugin, items, "action-message", plugin.cfg().guiText("btn-message"), "MSG", returnPage, friendId));
        }
        inv.setItem(22, FriendMenu.actionBtn(plugin, items, "action-remove", plugin.cfg().guiText("btn-remove"), "DEL", returnPage, friendId));
        inv.setItem(18, FriendMenu.actionBtn(plugin, items, "action-back", plugin.cfg().guiText("btn-back"), "BACK", returnPage, friendId));
        viewer.openInventory(inv);
    }

    public static ItemStack head(OfflinePlayer owner) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwningPlayer(owner);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    private static ItemStack glass(Material mat, String name) {
        ItemStack it = new ItemStack(mat);
        ItemMeta meta = it.getItemMeta();
        meta.setDisplayName(Text.c(name));
        it.setItemMeta(meta);
        return it;
    }

    private static ItemStack actionBtn(InfFriendPlugin plugin, ItemFactory items, String iconKey, String name, String action, int page, UUID friendId) {
        ItemStack it = items.icon(iconKey, Material.PAPER);
        items.applyName(it, name);
        ItemMeta meta = it.getItemMeta();
        meta.getPersistentDataContainer().set(MenuKeys.keyAction(plugin), PersistentDataType.STRING, (Object)action);
        meta.getPersistentDataContainer().set(MenuKeys.keyPage(plugin), PersistentDataType.INTEGER, (Object)page);
        if (friendId != null) {
            meta.getPersistentDataContainer().set(MenuKeys.keyFriendUuid(plugin), PersistentDataType.STRING, (Object)friendId.toString());
        }
        it.setItemMeta(meta);
        return it;
    }
}

