/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.inffriend.gui;

import com.masterok.inffriend.InfFriendPlugin;
import com.masterok.inffriend.gui.FriendMenu;
import com.masterok.inffriend.gui.MenuKeys;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class MenuListener
implements Listener {
    private final InfFriendPlugin plugin;

    public MenuListener(InfFriendPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        int curPage;
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        ItemStack current = e.getCurrentItem();
        if (current == null) {
            return;
        }
        String title = e.getView().getTitle();
        boolean isMain = title.equals(this.plugin.cfg().guiTitle());
        boolean isActions = title.startsWith(this.plugin.cfg().color("&b\u2726 \u0414\u0435\u0439\u0441\u0442\u0432\u0438\u044f:"));
        if (!isMain && !isActions) {
            return;
        }
        e.setCancelled(true);
        ItemMeta meta = current.getItemMeta();
        if (meta == null) {
            return;
        }
        String action = (String)meta.getPersistentDataContainer().get(MenuKeys.keyAction(this.plugin), PersistentDataType.STRING);
        Integer page = (Integer)meta.getPersistentDataContainer().get(MenuKeys.keyPage(this.plugin), PersistentDataType.INTEGER);
        String friendUuidStr = (String)meta.getPersistentDataContainer().get(MenuKeys.keyFriendUuid(this.plugin), PersistentDataType.STRING);
        int n = curPage = page == null ? 0 : page;
        if (action != null) {
            UUID uuid;
            if ("CLOSE".equals(action)) {
                p.closeInventory();
                return;
            }
            if ("REFRESH".equals(action)) {
                FriendMenu.openMain(this.plugin, p, curPage);
                return;
            }
            if ("PREV".equals(action)) {
                FriendMenu.openMain(this.plugin, p, curPage - 1);
                return;
            }
            if ("NEXT".equals(action)) {
                FriendMenu.openMain(this.plugin, p, curPage + 1);
                return;
            }
            if (friendUuidStr == null) {
                return;
            }
            try {
                uuid = UUID.fromString(friendUuidStr);
            }
            catch (Exception ex) {
                return;
            }
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)uuid);
            if ("BACK".equals(action)) {
                FriendMenu.openMain(this.plugin, p, curPage);
                return;
            }
            if ("TP".equals(action)) {
                if (!this.plugin.cfg().teleportEnabled()) {
                    return;
                }
                if (!this.plugin.friends().areFriends(p.getUniqueId(), uuid)) {
                    p.sendMessage(this.plugin.cfg().msg("not-friends"));
                    return;
                }
                if (!op.isOnline()) {
                    p.sendMessage(this.plugin.cfg().msg("player-offline"));
                    return;
                }
                p.teleport(op.getPlayer().getLocation());
                p.sendMessage(this.plugin.cfg().msg("teleported").replace("{player}", op.getName() == null ? "Unknown" : op.getName()));
                p.closeInventory();
                return;
            }
            if ("DEL".equals(action)) {
                if (!this.plugin.friends().areFriends(p.getUniqueId(), uuid)) {
                    p.sendMessage(this.plugin.cfg().msg("not-friends"));
                    return;
                }
                this.plugin.friends().removeFriendBoth(p.getUniqueId(), uuid);
                this.plugin.friends().repo().save();
                p.sendMessage(this.plugin.cfg().msg("friend-removed").replace("{player}", op.getName() == null ? "Unknown" : op.getName()));
                FriendMenu.openMain(this.plugin, p, curPage);
                return;
            }
            if ("MSG".equals(action)) {
                if (!this.plugin.cfg().privateMessagesEnabled()) {
                    return;
                }
                p.sendMessage(this.plugin.cfg().color(this.plugin.cfg().msg("prefix") + "&d\u041e\u0442\u043a\u0440\u043e\u0439 \u0447\u0430\u0442 \u0438 \u043d\u0430\u043f\u0438\u0448\u0438: &f/fmsg " + (op.getName() == null ? "\u043d\u0438\u043a" : op.getName()) + " \u0442\u0435\u043a\u0441\u0442"));
                p.closeInventory();
                return;
            }
            return;
        }
        if (isMain && friendUuidStr != null) {
            UUID uuid;
            try {
                uuid = UUID.fromString(friendUuidStr);
            }
            catch (Exception ex) {
                return;
            }
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)uuid);
            if (e.isShiftClick() && e.isRightClick()) {
                if (!this.plugin.cfg().sitOnHeadEnabled()) {
                    return;
                }
                if (!this.plugin.friends().areFriends(p.getUniqueId(), uuid)) {
                    p.sendMessage(this.plugin.cfg().msg("not-friends"));
                    return;
                }
                if (!op.isOnline()) {
                    p.sendMessage(this.plugin.cfg().msg("player-offline"));
                    return;
                }
                op.getPlayer().addPassenger((Entity)p);
                return;
            }
            if (e.isRightClick()) {
                if (!this.plugin.cfg().teleportEnabled()) {
                    return;
                }
                if (!this.plugin.friends().areFriends(p.getUniqueId(), uuid)) {
                    p.sendMessage(this.plugin.cfg().msg("not-friends"));
                    return;
                }
                if (!op.isOnline()) {
                    p.sendMessage(this.plugin.cfg().msg("player-offline"));
                    return;
                }
                p.teleport(op.getPlayer().getLocation());
                p.sendMessage(this.plugin.cfg().msg("teleported").replace("{player}", op.getName() == null ? "Unknown" : op.getName()));
                return;
            }
            if (e.isLeftClick()) {
                FriendMenu.openActions(this.plugin, p, uuid, curPage);
            }
        }
    }
}

