/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.inffriend;

import com.masterok.inffriend.commands.FriendCommand;
import com.masterok.inffriend.commands.FriendMsgCommand;
import com.masterok.inffriend.config.PluginConfig;
import com.masterok.inffriend.friend.FriendRequestService;
import com.masterok.inffriend.friend.FriendService;
import com.masterok.inffriend.gui.MenuListener;
import com.masterok.inffriend.listeners.LastSeenListener;
import com.masterok.inffriend.listeners.SitOnHeadListener;
import com.masterok.inffriend.storage.YamlFriendRepository;
import com.masterok.inffriend.update.UpdateChecker;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class InfFriendPlugin
extends JavaPlugin {
    private PluginConfig pluginConfig;
    private FriendService friendService;
    private FriendRequestService requestService;

    public void onEnable() {
        this.saveDefaultConfig();
        this.pluginConfig = new PluginConfig(this);
        YamlFriendRepository repo = new YamlFriendRepository(this);
        repo.load();
        this.friendService = new FriendService(repo);
        this.requestService = new FriendRequestService();
        this.getServer().getPluginManager().registerEvents((Listener)new MenuListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new LastSeenListener(this.friendService), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SitOnHeadListener(this, this.friendService), (Plugin)this);
        FriendCommand friendCmd = new FriendCommand(this, this.friendService, this.requestService);
        this.getCommand("friend").setExecutor((CommandExecutor)friendCmd);
        this.getCommand("friend").setTabCompleter((TabCompleter)friendCmd);
        FriendMsgCommand msgCmd = new FriendMsgCommand(this, this.friendService);
        this.getCommand("fmsg").setExecutor((CommandExecutor)msgCmd);
        this.getCommand("fmsg").setTabCompleter((TabCompleter)msgCmd);
        UpdateChecker.checkAsync(this, "https://masterok.space/Plugins/InfFriends/version.txt");
        this.getLogger().info("InfFriend enabled");
    }

    public void onDisable() {
        this.friendService.repo().save();
    }

    public void reloadAll() {
        this.reloadConfig();
        this.pluginConfig = new PluginConfig(this);
    }

    public PluginConfig cfg() {
        return this.pluginConfig;
    }

    public FriendService friends() {
        return this.friendService;
    }

    public FriendRequestService requests() {
        return this.requestService;
    }
}

