/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.inffriend.commands;

import com.masterok.inffriend.InfFriendPlugin;
import com.masterok.inffriend.friend.FriendRequestService;
import com.masterok.inffriend.friend.FriendService;
import com.masterok.inffriend.gui.FriendMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class FriendCommand
implements CommandExecutor,
TabCompleter {
    private final InfFriendPlugin plugin;
    private final FriendService friends;
    private final FriendRequestService requests;

    public FriendCommand(InfFriendPlugin plugin, FriendService friends, FriendRequestService requests) {
        this.plugin = plugin;
        this.friends = friends;
        this.requests = requests;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        this.requests.cleanupExpired(this.plugin.cfg().requestExpireMillis());
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.cfg().msg("only-players"));
            return true;
        }
        Player p = (Player)sender;
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            this.sendHelp(p);
            return true;
        }
        String sub = args[0].toLowerCase();
        if (sub.equals("menu")) {
            FriendMenu.openMain(this.plugin, p, 0);
            return true;
        }
        if (sub.equals("reload")) {
            if (!p.hasPermission("inffriend.reload")) {
                p.sendMessage(this.plugin.cfg().msg("no-permission"));
                return true;
            }
            this.plugin.reloadAll();
            p.sendMessage(this.plugin.cfg().color(this.plugin.cfg().msg("prefix") + "&a\u041a\u043e\u043d\u0444\u0438\u0433 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d."));
            return true;
        }
        if (sub.equals("add") && args.length >= 2) {
            OfflinePlayer t = Bukkit.getOfflinePlayer((String)args[1]);
            if (t.getName() == null) {
                p.sendMessage(this.plugin.cfg().msg("player-never-played"));
                return true;
            }
            if (t.getUniqueId().equals(p.getUniqueId())) {
                p.sendMessage(this.plugin.cfg().msg("cannot-add-self"));
                return true;
            }
            if (this.friends.areFriends(p.getUniqueId(), t.getUniqueId())) {
                p.sendMessage(this.plugin.cfg().msg("already-friends"));
                return true;
            }
            if (this.friends.friendsOf(p.getUniqueId()).size() >= this.plugin.cfg().maxFriends()) {
                p.sendMessage(this.plugin.cfg().color(this.plugin.cfg().msg("prefix") + "&c\u041b\u0438\u043c\u0438\u0442 \u0434\u0440\u0443\u0437\u0435\u0439 \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442."));
                return true;
            }
            this.requests.create(p.getUniqueId(), t.getUniqueId());
            p.sendMessage(this.plugin.cfg().msg("request-sent").replace("{player}", t.getName()));
            if (t.isOnline()) {
                Player receiver = t.getPlayer();
                receiver.sendMessage(this.plugin.cfg().msg("request-received").replace("{player}", p.getName()));
                TextComponent accept = new TextComponent(this.plugin.cfg().color("&a[\u2713 \u041f\u0440\u0438\u043d\u044f\u0442\u044c]"));
                accept.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/friend accept " + p.getName()));
                accept.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.plugin.cfg().color("&7\u041d\u0430\u0436\u043c\u0438, \u0447\u0442\u043e\u0431\u044b \u043f\u0440\u0438\u043d\u044f\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441")).create()));
                TextComponent space = new TextComponent("  ");
                TextComponent deny = new TextComponent(this.plugin.cfg().color("&c[\u2717 \u041e\u0442\u043a\u043b\u043e\u043d\u0438\u0442\u044c]"));
                deny.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/friend deny " + p.getName()));
                deny.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.plugin.cfg().color("&7\u041d\u0430\u0436\u043c\u0438, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043a\u043b\u043e\u043d\u0438\u0442\u044c")).create()));
                receiver.spigot().sendMessage(new BaseComponent[]{accept, space, deny});
            }
            return true;
        }
        if ((sub.equals("accept") || sub.equals("yes")) && args.length >= 2) {
            OfflinePlayer from = Bukkit.getOfflinePlayer((String)args[1]);
            if (from.getName() == null) {
                p.sendMessage(this.plugin.cfg().msg("player-never-played"));
                return true;
            }
            FriendRequestService.Request r = this.requests.get(from.getUniqueId(), p.getUniqueId());
            if (r == null) {
                p.sendMessage(this.plugin.cfg().msg("no-request"));
                return true;
            }
            long expire = this.plugin.cfg().requestExpireMillis();
            if (System.currentTimeMillis() - r.createdMillis > expire) {
                this.requests.remove(from.getUniqueId(), p.getUniqueId());
                p.sendMessage(this.plugin.cfg().msg("request-expired"));
                return true;
            }
            this.friends.addFriendBoth(p.getUniqueId(), from.getUniqueId());
            this.friends.repo().save();
            this.requests.remove(from.getUniqueId(), p.getUniqueId());
            p.sendMessage(this.plugin.cfg().msg("now-friends").replace("{player}", from.getName()));
            if (from.isOnline()) {
                from.getPlayer().sendMessage(this.plugin.cfg().msg("now-friends").replace("{player}", p.getName()));
            }
            return true;
        }
        if ((sub.equals("deny") || sub.equals("no")) && args.length >= 2) {
            OfflinePlayer from = Bukkit.getOfflinePlayer((String)args[1]);
            if (from.getName() == null) {
                p.sendMessage(this.plugin.cfg().msg("player-never-played"));
                return true;
            }
            FriendRequestService.Request r = this.requests.get(from.getUniqueId(), p.getUniqueId());
            if (r == null) {
                p.sendMessage(this.plugin.cfg().msg("no-request"));
                return true;
            }
            this.requests.remove(from.getUniqueId(), p.getUniqueId());
            p.sendMessage(this.plugin.cfg().msg("request-denied").replace("{player}", from.getName()));
            return true;
        }
        if ((sub.equals("remove") || sub.equals("del")) && args.length >= 2) {
            OfflinePlayer t = Bukkit.getOfflinePlayer((String)args[1]);
            if (t.getName() == null) {
                p.sendMessage(this.plugin.cfg().msg("player-never-played"));
                return true;
            }
            if (!this.friends.areFriends(p.getUniqueId(), t.getUniqueId())) {
                p.sendMessage(this.plugin.cfg().msg("not-friends"));
                return true;
            }
            this.friends.removeFriendBoth(p.getUniqueId(), t.getUniqueId());
            this.friends.repo().save();
            p.sendMessage(this.plugin.cfg().msg("friend-removed").replace("{player}", t.getName()));
            if (t.isOnline()) {
                t.getPlayer().sendMessage(this.plugin.cfg().msg("friend-removed").replace("{player}", p.getName()));
            }
            return true;
        }
        this.sendHelp(p);
        return true;
    }

    private void sendHelp(Player p) {
        boolean canReload = p.hasPermission("inffriend.reload");
        String prefix = this.plugin.cfg().raw("messages.prefix");
        for (String line : this.plugin.cfg().helpLines(canReload)) {
            p.sendMessage(prefix + line);
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player p = (Player)sender;
        if (args.length == 1) {
            ArrayList<String> subs = new ArrayList<String>();
            subs.add("help");
            subs.add("menu");
            subs.add("add");
            subs.add("accept");
            subs.add("deny");
            subs.add("remove");
            if (p.hasPermission("inffriend.reload")) {
                subs.add("reload");
            }
            return this.filterStartsWith(subs, args[0]);
        }
        if (args.length == 2) {
            String sub = args[0].toLowerCase();
            if (sub.equals("add")) {
                ArrayList<String> names = new ArrayList<String>();
                for (Player pl : Bukkit.getOnlinePlayers()) {
                    if (pl.getUniqueId().equals(p.getUniqueId()) || this.friends.areFriends(p.getUniqueId(), pl.getUniqueId())) continue;
                    names.add(pl.getName());
                }
                Collections.sort(names);
                return this.filterStartsWith(names, args[1]);
            }
            if (sub.equals("accept") || sub.equals("deny") || sub.equals("remove") || sub.equals("del")) {
                ArrayList<String> names = new ArrayList<String>();
                for (Player pl : Bukkit.getOnlinePlayers()) {
                    if (pl.getUniqueId().equals(p.getUniqueId())) continue;
                    names.add(pl.getName());
                }
                Collections.sort(names);
                return this.filterStartsWith(names, args[1]);
            }
        }
        return Collections.emptyList();
    }

    private List<String> filterStartsWith(List<String> list, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        String p = prefix.toLowerCase();
        ArrayList<String> out = new ArrayList<String>();
        for (String s : list) {
            if (s == null || !s.toLowerCase().startsWith(p)) continue;
            out.add(s);
        }
        return out;
    }
}

