/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.inffriend.compat;

import com.masterok.inffriend.InfFriendPlugin;
import com.masterok.inffriend.util.Text;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemFactory {
    private final InfFriendPlugin plugin;

    public ItemFactory(InfFriendPlugin plugin) {
        this.plugin = plugin;
    }

    public ItemStack icon(String key, Material fallback) {
        ConfigurationSection sec = this.plugin.getConfig().getConfigurationSection("icons." + key);
        if (sec == null) {
            return new ItemStack(fallback);
        }
        String type = sec.getString("type", "MATERIAL").toUpperCase();
        if ("ITEMSADDER".equals(type)) {
            String id = sec.getString("id", "");
            ItemStack ia = this.buildItemsAdder(id);
            if (ia != null) {
                return ia;
            }
            return new ItemStack(fallback);
        }
        if ("ORAXEN".equals(type)) {
            String id = sec.getString("id", "");
            ItemStack ox = this.buildOraxen(id);
            if (ox != null) {
                return ox;
            }
            return new ItemStack(fallback);
        }
        if ("CUSTOM_MODEL_DATA".equals(type)) {
            Material mat = this.readMaterial(sec.getString("material"), fallback);
            int cmd = sec.getInt("cmd", 0);
            ItemStack it = new ItemStack(mat);
            ItemMeta meta = it.getItemMeta();
            if (meta != null) {
                meta.setCustomModelData(Integer.valueOf(cmd));
                it.setItemMeta(meta);
            }
            return it;
        }
        Material mat = this.readMaterial(sec.getString("material"), fallback);
        return new ItemStack(mat);
    }

    public void applyName(ItemStack it, String name) {
        if (it == null) {
            return;
        }
        ItemMeta meta = it.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.setDisplayName(Text.c(name));
        it.setItemMeta(meta);
    }

    private Material readMaterial(String s, Material fallback) {
        if (s == null) {
            return fallback;
        }
        try {
            Material m = Material.valueOf((String)s.toUpperCase());
            if (m != null) {
                return m;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fallback;
    }

    private ItemStack buildItemsAdder(String namespacedId) {
        if (namespacedId == null || namespacedId.trim().isEmpty()) {
            return null;
        }
        if (Bukkit.getPluginManager().getPlugin("ItemsAdder") == null) {
            return null;
        }
        try {
            Class<?> customStack = Class.forName("dev.lone.itemsadder.api.CustomStack");
            Object instance = customStack.getMethod("getInstance", String.class).invoke(null, namespacedId);
            if (instance == null) {
                return null;
            }
            return (ItemStack)instance.getClass().getMethod("getItemStack", new Class[0]).invoke(instance, new Object[0]);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private ItemStack buildOraxen(String oraxenId) {
        if (oraxenId == null || oraxenId.trim().isEmpty()) {
            return null;
        }
        if (Bukkit.getPluginManager().getPlugin("Oraxen") == null) {
            return null;
        }
        try {
            Class<?> oraxenItems = Class.forName("io.th0rgal.oraxen.api.OraxenItems");
            Object builder = oraxenItems.getMethod("getItemById", String.class).invoke(null, oraxenId);
            if (builder == null) {
                return null;
            }
            return (ItemStack)builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
        }
        catch (Throwable ignored) {
            return null;
        }
    }
}

