/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.inffriend.config;

import com.masterok.inffriend.InfFriendPlugin;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;

public class PluginConfig {
    private final InfFriendPlugin plugin;

    public PluginConfig(InfFriendPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean teleportEnabled() {
        return this.plugin.getConfig().getBoolean("features.teleport-to-friend", true);
    }

    public boolean coordsEnabled() {
        return this.plugin.getConfig().getBoolean("features.show-friend-coordinates", true);
    }

    public boolean healthEnabled() {
        return this.plugin.getConfig().getBoolean("features.show-friend-health", true);
    }

    public boolean sitOnHeadEnabled() {
        return this.plugin.getConfig().getBoolean("features.sit-on-head", true);
    }

    public boolean privateMessagesEnabled() {
        return this.plugin.getConfig().getBoolean("features.private-messages", true);
    }

    public int maxFriends() {
        return this.plugin.getConfig().getInt("limits.max-friends", 50);
    }

    public long requestExpireMillis() {
        int sec = this.plugin.getConfig().getInt("requests.expire-seconds", 120);
        if (sec < 10) {
            sec = 10;
        }
        return (long)sec * 1000L;
    }

    public String guiTitle() {
        return this.color(this.plugin.getConfig().getString("gui.title", "&b&lInfFriend &7| &f\u0414\u0440\u0443\u0437\u044c\u044f"));
    }

    public int guiSize() {
        int size = this.plugin.getConfig().getInt("gui.size", 54);
        if (size % 9 != 0) {
            size = 54;
        }
        if (size < 9) {
            size = 9;
        }
        if (size > 54) {
            size = 54;
        }
        return size;
    }

    public String msg(String key) {
        String prefix = this.plugin.getConfig().getString("messages.prefix", "&b[InfFriend]&r ");
        String raw = this.plugin.getConfig().getString("messages." + key, "");
        return this.color(prefix + raw);
    }

    public String raw(String path) {
        return this.color(this.plugin.getConfig().getString(path, ""));
    }

    public List<String> helpLines(boolean canReload) {
        List raw = this.plugin.getConfig().getStringList("messages.help");
        ArrayList<String> out = new ArrayList<String>();
        for (String s : raw) {
            if (s == null || !canReload && s.toLowerCase().contains("/friend reload")) continue;
            out.add(this.color(s));
        }
        return out;
    }

    public String guiText(String key) {
        return this.color(this.plugin.getConfig().getString("gui-text." + key, ""));
    }

    public String color(String s) {
        if (s == null) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }
}

