/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.inffriend.storage;

import com.masterok.inffriend.InfFriendPlugin;
import com.masterok.inffriend.storage.FriendRepository;
import com.masterok.inffriend.storage.model.FriendEntry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlFriendRepository
implements FriendRepository {
    private final InfFriendPlugin plugin;
    private final File file;
    private YamlConfiguration yaml;
    private final Map<UUID, FriendEntry> data = new HashMap<UUID, FriendEntry>();

    public YamlFriendRepository(InfFriendPlugin plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "friends.yml");
    }

    @Override
    public Optional<FriendEntry> get(UUID owner) {
        return Optional.ofNullable(this.data.get(owner));
    }

    @Override
    public FriendEntry getOrCreate(UUID owner) {
        return this.data.computeIfAbsent(owner, FriendEntry::new);
    }

    @Override
    public Set<UUID> getFriends(UUID owner) {
        return new HashSet<UUID>(this.getOrCreate(owner).friends());
    }

    @Override
    public void addFriend(UUID owner, UUID friend) {
        this.getOrCreate(owner).friends().add(friend);
    }

    @Override
    public void removeFriend(UUID owner, UUID friend) {
        this.getOrCreate(owner).friends().remove(friend);
    }

    @Override
    public boolean areFriends(UUID a, UUID b) {
        return this.getOrCreate(a).friends().contains(b) && this.getOrCreate(b).friends().contains(a);
    }

    @Override
    public long getLastSeen(UUID player) {
        return this.getOrCreate(player).lastSeenMillis();
    }

    @Override
    public void setLastSeen(UUID player, long millis) {
        this.getOrCreate(player).setLastSeenMillis(millis);
    }

    @Override
    public void load() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Cannot create friends.yml: " + e.getMessage());
            }
        }
        this.yaml = YamlConfiguration.loadConfiguration((File)this.file);
        this.data.clear();
        ConfigurationSection players = this.yaml.getConfigurationSection("players");
        if (players == null) {
            return;
        }
        for (String ownerKey : players.getKeys(false)) {
            UUID owner;
            try {
                owner = UUID.fromString(ownerKey);
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
            FriendEntry entry = new FriendEntry(owner);
            entry.setLastSeenMillis(players.getLong(ownerKey + ".lastSeen", 0L));
            List list = players.getStringList(ownerKey + ".friends");
            for (String s : list) {
                try {
                    entry.friends().add(UUID.fromString(s));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            this.data.put(owner, entry);
        }
    }

    @Override
    public void save() {
        if (this.yaml == null) {
            this.yaml = new YamlConfiguration();
        }
        this.yaml.set("players", null);
        for (FriendEntry entry : this.data.values()) {
            String key = "players." + entry.owner().toString();
            this.yaml.set(key + ".lastSeen", (Object)entry.lastSeenMillis());
            ArrayList<String> friends = new ArrayList<String>();
            for (UUID u : entry.friends()) {
                friends.add(u.toString());
            }
            this.yaml.set(key + ".friends", friends);
        }
        try {
            this.yaml.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Cannot save friends.yml: " + e.getMessage());
        }
    }
}

