/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.inffriend.update;

import com.masterok.inffriend.InfFriendPlugin;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public final class UpdateChecker {
    private UpdateChecker() {
    }

    public static void checkAsync(final InfFriendPlugin plugin, final String urlString) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                try {
                    String latest;
                    Result res = UpdateChecker.fetch(urlString);
                    if (res == null || res.latestVersion == null || res.latestVersion.trim().isEmpty()) {
                        plugin.getLogger().warning("Update check: cannot read version.txt (empty response)");
                        return;
                    }
                    String current = plugin.getDescription().getVersion();
                    if (!current.equalsIgnoreCase(latest = res.latestVersion.trim())) {
                        plugin.getLogger().warning("=================================================");
                        plugin.getLogger().warning("InfFriend: \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043d\u043e\u0432\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f!");
                        plugin.getLogger().warning("\u0422\u0435\u043a\u0443\u0449\u0430\u044f: " + current);
                        plugin.getLogger().warning("\u041d\u043e\u0432\u0430\u044f:    " + latest);
                        if (res.updateUrl != null && !res.updateUrl.trim().isEmpty()) {
                            plugin.getLogger().warning("\u0421\u0441\u044b\u043b\u043a\u0430:   " + res.updateUrl.trim());
                        }
                        plugin.getLogger().warning("=================================================");
                    } else {
                        plugin.getLogger().info("InfFriend: \u0432\u0435\u0440\u0441\u0438\u044f \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u0430 (" + current + ")");
                    }
                }
                catch (Exception e) {
                    plugin.getLogger().warning("Update check failed: " + e.getClass().getSimpleName() + ": " + e.getMessage());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Result fetch(String urlString) throws Exception {
        HttpURLConnection con = null;
        BufferedReader reader = null;
        try {
            URL url = new URL(urlString);
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setConnectTimeout(5000);
            con.setReadTimeout(5000);
            con.setRequestProperty("User-Agent", "InfFriendUpdateChecker");
            int code = con.getResponseCode();
            if (code != 200) {
                Result result = null;
                return result;
            }
            reader = new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8"));
            String line1 = reader.readLine();
            String line2 = reader.readLine();
            Result r = new Result();
            r.latestVersion = line1;
            r.updateUrl = line2;
            Result result = r;
            return result;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (con != null) {
                    con.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static class Result {
        String latestVersion;
        String updateUrl;

        private Result() {
        }
    }
}

