/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.Inffriends.manager;

import com.masterok.Inffriends.InfFriends;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final InfFriends plugin;
    private FileConfiguration config;
    private FileConfiguration messagesConfig;
    private File configFile;
    private File messagesFile;

    public ConfigManager(InfFriends plugin) {
        this.plugin = plugin;
    }

    public void loadConfigs() {
        this.plugin.saveDefaultConfig();
        this.createMessagesFile();
        this.config = this.plugin.getConfig();
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.setupDefaults();
    }

    private void createMessagesFile() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
    }

    private void setupDefaults() {
    }

    public void saveConfig() {
        this.plugin.saveConfig();
    }

    public void reloadConfigs() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }

    public boolean isPvpProtectionEnabled() {
        return this.config.getBoolean("settings.pvp-protection", true);
    }

    public boolean areJoinLeaveNotificationsEnabled() {
        return this.config.getBoolean("settings.join-leave-notifications", true);
    }

    public int getMaxFriends() {
        return this.config.getInt("settings.max-friends", 0);
    }

    public boolean isAutoAcceptRequestsEnabled() {
        return this.config.getBoolean("settings.auto-accept-requests", false);
    }

    public int getRequestExpireTime() {
        return this.config.getInt("settings.request-expire-time", 300);
    }

    public boolean isSitEnabled() {
        return this.config.getBoolean("settings.sit-enabled", true);
    }

    public boolean isGuiEnabled() {
        return this.config.getBoolean("gui.enabled", true);
    }

    public boolean isTeleportAllowed() {
        return this.config.getBoolean("gui.allow-teleport", true);
    }

    public boolean isMessagesAllowed() {
        return this.config.getBoolean("gui.allow-messages", true);
    }

    public boolean isShowLocationEnabled() {
        return this.config.getBoolean("gui.show-location", true);
    }

    public boolean isShowHealthEnabled() {
        return this.config.getBoolean("gui.show-health", true);
    }

    public boolean isShowGuiSettings() {
        return this.config.getBoolean("gui.show-settings", true);
    }

    public boolean isRgbEnabled() {
        return this.config.getBoolean("rgb.enabled", true);
    }

    public int getAnimationSpeed() {
        return this.config.getInt("rgb.animation-speed", 5);
    }

    public List<String> getPrimaryColors() {
        ArrayList<String> hexColors = this.config.getStringList("rgb.primary-colors");
        if (hexColors.isEmpty()) {
            hexColors = new ArrayList<String>();
            hexColors.add("#FF6B6B");
            hexColors.add("#4ECDC4");
            hexColors.add("#45B7D1");
            hexColors.add("#96CEB4");
            hexColors.add("#FFEAA7");
            hexColors.add("#DDA0DD");
        }
        return hexColors;
    }

    public String getMessagePrefix() {
        return this.config.getString("messages.prefix", "&8[&dInfFriends&8]");
    }

    public String getDateFormat() {
        return this.config.getString("messages.date-format", "dd.MM.yyyy HH:mm");
    }
}

