/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.Inffriends.util;

import com.masterok.Inffriends.InfFriends;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class UpdateChecker
implements Listener {
    private final InfFriends plugin;
    private final String PASTE_BIN_ID = "7UAfqd6D";
    private final Map<String, PluginUpdateInfo> updates = new HashMap<String, PluginUpdateInfo>();
    private boolean updateAvailable = false;

    public UpdateChecker(InfFriends plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String line;
                String rawUrl = "https://pastebin.com/raw/7UAfqd6D";
                URL url = new URL(rawUrl);
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                int lineNumber = 0;
                this.plugin.getLogger().info("\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e URL: " + rawUrl);
                while ((line = reader.readLine()) != null) {
                    this.processLine(line, ++lineNumber);
                }
                reader.close();
                this.checkInfFriendsUpdate();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f: " + e.getMessage());
            }
        });
    }

    private void processLine(String line, int lineNumber) {
        String[] parts;
        if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
            return;
        }
        if (line.contains("-") && (parts = line.split("-", 3)).length == 3) {
            String pluginName = parts[0].trim();
            String latestVersion = parts[1].trim();
            String downloadUrl = parts[2].trim();
            if (!(pluginName.isEmpty() || latestVersion.isEmpty() || downloadUrl.isEmpty())) {
                this.updates.put(pluginName, new PluginUpdateInfo(pluginName, latestVersion, downloadUrl));
                this.plugin.getLogger().info("\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u043b\u044f: " + pluginName + " \u0432\u0435\u0440\u0441\u0438\u044f " + latestVersion);
            }
        }
    }

    private void checkInfFriendsUpdate() {
        PluginUpdateInfo infFriendsUpdate = this.updates.get("InfFriends");
        if (infFriendsUpdate != null) {
            String currentVersion = this.plugin.getDescription().getVersion();
            String latestVersion = infFriendsUpdate.latestVersion;
            this.plugin.getLogger().info("\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f: " + currentVersion + ", \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0432\u0435\u0440\u0441\u0438\u044f: " + latestVersion);
            if (this.isNewerVersion(currentVersion, latestVersion)) {
                this.updateAvailable = true;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    this.plugin.getLogger().warning("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                    this.plugin.getLogger().warning("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 InfFriends!");
                    this.plugin.getLogger().warning("\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f: " + currentVersion);
                    this.plugin.getLogger().warning("\u041d\u043e\u0432\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f: " + latestVersion);
                    this.plugin.getLogger().warning("\u0421\u043a\u0430\u0447\u0430\u0442\u044c: " + infFriendsUpdate.downloadUrl);
                    this.plugin.getLogger().warning("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                });
            } else {
                this.plugin.getLogger().info("\u2713 InfFriends \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d \u0434\u043e \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438: " + currentVersion);
            }
        } else {
            this.plugin.getLogger().warning("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f\u0445 \u0434\u043b\u044f InfFriends \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
            this.plugin.getLogger().warning("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043f\u043b\u0430\u0433\u0438\u043d\u044b \u0432 PasteBin: " + String.join((CharSequence)", ", this.updates.keySet()));
        }
    }

    private boolean isNewerVersion(String current, String latest) {
        try {
            String[] currentParts = current.split("\\.");
            String[] latestParts = latest.split("\\.");
            for (int i = 0; i < Math.min(currentParts.length, latestParts.length); ++i) {
                int currentNum = Integer.parseInt(currentParts[i]);
                int latestNum = Integer.parseInt(latestParts[i]);
                if (latestNum > currentNum) {
                    return true;
                }
                if (latestNum >= currentNum) continue;
                return false;
            }
            return latestParts.length > currentParts.length;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.updateAvailable && player.isOp()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.sendUpdateMessage(player), 60L);
        }
    }

    private void sendUpdateMessage(Player player) {
        PluginUpdateInfo infFriendsUpdate = this.updates.get("InfFriends");
        if (infFriendsUpdate != null) {
            player.sendMessage("\u00a76\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            player.sendMessage("\u00a7e\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u00a76InfFriends\u00a7e!");
            player.sendMessage("\u00a7a\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f: \u00a72" + this.plugin.getDescription().getVersion());
            player.sendMessage("\u00a7a\u041d\u043e\u0432\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f: \u00a72" + infFriendsUpdate.latestVersion);
            player.sendMessage("\u00a7e\u0421\u043a\u0430\u0447\u0430\u0442\u044c: \u00a76" + infFriendsUpdate.downloadUrl);
            player.sendMessage("\u00a76\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        }
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public Map<String, PluginUpdateInfo> getUpdates() {
        return this.updates;
    }

    private static class PluginUpdateInfo {
        String pluginName;
        String latestVersion;
        String downloadUrl;

        PluginUpdateInfo(String pluginName, String latestVersion, String downloadUrl) {
            this.pluginName = pluginName;
            this.latestVersion = latestVersion;
            this.downloadUrl = downloadUrl;
        }
    }
}

