/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.Inffriends.gui;

import com.masterok.Inffriends.InfFriends;
import com.masterok.Inffriends.util.ColorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class FriendGUI
implements Listener {
    private final InfFriends plugin;
    private final Map<UUID, Inventory> playerGuis;
    private final Map<UUID, String> pendingMessages;

    public FriendGUI(InfFriends plugin) {
        this.plugin = plugin;
        this.playerGuis = new HashMap<UUID, Inventory>();
        this.pendingMessages = new HashMap<UUID, String>();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean isGuiEnabled() {
        return this.plugin.getConfigManager().getConfig().getBoolean("gui.enabled", true);
    }

    public boolean isTeleportAllowed() {
        return this.plugin.getConfigManager().getConfig().getBoolean("gui.allow-teleport", true);
    }

    public boolean isMessagesAllowed() {
        return this.plugin.getConfigManager().getConfig().getBoolean("gui.allow-messages", true);
    }

    public boolean hasPendingMessage(Player player) {
        return this.pendingMessages.containsKey(player.getUniqueId());
    }

    public void openFriendList(Player player) {
        if (!this.isGuiEnabled()) {
            ColorUtils.sendMessage((CommandSender)player, "&cGUI \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0433\u0438\u043d\u0430");
            return;
        }
        try {
            Player friend;
            if (player.getOpenInventory() != null && this.playerGuis.containsKey(player.getUniqueId())) {
                player.closeInventory();
            }
            List<String> friendNames = this.plugin.getFriendManager().getFriendNames(player.getUniqueId());
            List<Player> onlineFriends = this.plugin.getFriendManager().getOnlineFriends(player.getUniqueId());
            int guiSize = 54;
            String guiTitle = ColorUtils.colorize("&6\u0414\u0440\u0443\u0437\u044c\u044f");
            Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)guiSize, (String)guiTitle);
            this.playerGuis.put(player.getUniqueId(), gui);
            int slot = 0;
            for (String friendName : friendNames) {
                friend = Bukkit.getPlayer((String)friendName);
                if (friend == null || !friend.isOnline()) continue;
                if (slot >= 45) break;
                gui.setItem(slot, this.createOnlineFriendItem(friend));
                ++slot;
            }
            for (String friendName : friendNames) {
                friend = Bukkit.getPlayer((String)friendName);
                if (friend != null && friend.isOnline()) continue;
                if (slot >= 45) break;
                gui.setItem(slot, this.createOfflineFriendItem(friendName));
                ++slot;
            }
            this.addBottomPanel(gui, player, onlineFriends.size(), friendNames.size());
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (player.isOnline()) {
                    player.openInventory(gui);
                }
            }, 1L);
        }
        catch (Exception e) {
            ColorUtils.sendMessage((CommandSender)player, "&c\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0438 GUI");
            this.plugin.getLogger().severe("Error opening GUI: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private ItemStack createOnlineFriendItem(Player friend) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta != null) {
            String displayName = "&a" + friend.getName();
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("&2\u25cf \u043e\u043d\u043b\u0430\u0439\u043d");
            lore.add("");
            if (this.isTeleportAllowed()) {
                lore.add("&e\u041b\u041a\u041c - \u0422\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f");
            }
            lore.add("&c\u041f\u041a\u041c - \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0437 \u0434\u0440\u0443\u0437\u0435\u0439");
            if (this.isMessagesAllowed()) {
                lore.add("&bShift+\u041b\u041a\u041c - \u041d\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
            }
            lore.add("");
            if (this.plugin.getConfigManager().isShowLocationEnabled()) {
                lore.add("&7\u041c\u0435\u0441\u0442\u043e\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435: &f" + this.getFormattedLocation(friend.getLocation()));
            } else {
                lore.add("&7\u041c\u0435\u0441\u0442\u043e\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435: &c\u041d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e");
            }
            if (this.plugin.getConfigManager().isShowHealthEnabled()) {
                lore.add("&7\u0417\u0434\u043e\u0440\u043e\u0432\u044c\u0435: &c\u2764 " + String.format("%.1f", friend.getHealth()));
            }
            meta.setDisplayName(ColorUtils.colorize(displayName));
            meta.setLore(this.colorizeList(lore));
            meta.setOwningPlayer((OfflinePlayer)friend);
            skull.setItemMeta((ItemMeta)meta);
        }
        return skull;
    }

    private ItemStack createOfflineFriendItem(String friendName) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta != null) {
            block3: {
                String displayName = "&7" + friendName;
                ArrayList<String> lore = new ArrayList<String>();
                lore.add("&8\u25cf \u043e\u0444\u0444\u043b\u0430\u0439\u043d");
                lore.add("");
                lore.add("&c\u041f\u041a\u041c - \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0437 \u0434\u0440\u0443\u0437\u0435\u0439");
                lore.add("");
                lore.add("&7\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u0432\u0445\u043e\u0434: &f" + this.getLastSeen(friendName));
                meta.setDisplayName(ColorUtils.colorize(displayName));
                meta.setLore(this.colorizeList(lore));
                try {
                    meta.setOwningPlayer(Bukkit.getOfflinePlayer((String)friendName));
                }
                catch (Exception e) {
                    skull = new ItemStack(Material.SKELETON_SKULL);
                    meta = (SkullMeta)skull.getItemMeta();
                    if (meta == null) break block3;
                    meta.setDisplayName(ColorUtils.colorize(displayName));
                    meta.setLore(this.colorizeList(lore));
                }
            }
            skull.setItemMeta((ItemMeta)meta);
        }
        return skull;
    }

    private String getFormattedLocation(Location loc) {
        return String.format("X: %d, Y: %d, Z: %d", loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    private String getLastSeen(String playerName) {
        return "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e";
    }

    private void addBottomPanel(Inventory gui, Player player, int onlineCount, int totalCount) {
        ArrayList<String> infoLore = new ArrayList<String>();
        infoLore.add("&a\u0412\u0441\u0435\u0433\u043e \u0434\u0440\u0443\u0437\u0435\u0439: &2" + totalCount);
        infoLore.add("&a\u041e\u043d\u043b\u0430\u0439\u043d: &2" + onlineCount);
        infoLore.add("&c\u041e\u0444\u0444\u043b\u0430\u0439\u043d: &4" + (totalCount - onlineCount));
        if (this.plugin.getConfigManager().isShowGuiSettings() && player.hasPermission("inffriends.admin")) {
            infoLore.add("");
            infoLore.add("&e\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 GUI:");
            infoLore.add("&7" + (this.isTeleportAllowed() ? "[+]" : "[-]") + " \u0422\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0430\u0446\u0438\u044f: " + (this.isTeleportAllowed() ? "&a\u0412\u041a\u041b" : "&c\u0412\u042b\u041a\u041b"));
            infoLore.add("&7" + (this.isMessagesAllowed() ? "[+]" : "[-]") + " \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f: " + (this.isMessagesAllowed() ? "&a\u0412\u041a\u041b" : "&c\u0412\u042b\u041a\u041b"));
            infoLore.add("&7" + (this.plugin.getConfigManager().isShowLocationEnabled() ? "[+]" : "[-]") + " \u041b\u043e\u043a\u0430\u0446\u0438\u044f: " + (this.plugin.getConfigManager().isShowLocationEnabled() ? "&a\u0412\u041a\u041b" : "&c\u0412\u042b\u041a\u041b"));
            infoLore.add("&7" + (this.plugin.getConfigManager().isShowHealthEnabled() ? "[+]" : "[-]") + " \u0417\u0434\u043e\u0440\u043e\u0432\u044c\u0435: " + (this.plugin.getConfigManager().isShowHealthEnabled() ? "&a\u0412\u041a\u041b" : "&c\u0412\u042b\u041a\u041b"));
        }
        ItemStack info = this.createGuiItem(Material.COMPASS, "&b\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0434\u0440\u0443\u0437\u044c\u044f\u0445", infoLore.toArray(new String[0]));
        gui.setItem(45, info);
        ItemStack refresh = this.createGuiItem(Material.EMERALD, "&a\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0447\u0442\u043e\u0431\u044b \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0434\u0440\u0443\u0437\u0435\u0439");
        gui.setItem(49, refresh);
        ItemStack close = this.createGuiItem(Material.BARRIER, "&c\u0417\u0430\u043a\u0440\u044b\u0442\u044c", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0447\u0442\u043e\u0431\u044b \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u043c\u0435\u043d\u044e");
        gui.setItem(53, close);
        ItemStack decoration = this.createGuiItem(Material.LIGHT_BLUE_STAINED_GLASS_PANE, " ", " ");
        for (int i = 46; i <= 52; ++i) {
            if (i == 49) continue;
            gui.setItem(i, decoration);
        }
    }

    private ItemStack createGuiItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(ColorUtils.colorize(name));
            if (lore.length > 0) {
                ArrayList<String> coloredLore = new ArrayList<String>();
                for (String line : lore) {
                    coloredLore.add(ColorUtils.colorize(line));
                }
                meta.setLore(coloredLore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private List<String> colorizeList(List<String> list) {
        ArrayList<String> coloredList = new ArrayList<String>();
        for (String line : list) {
            coloredList.add(ColorUtils.colorize(line));
        }
        return coloredList;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null || !this.playerGuis.containsKey(player.getUniqueId())) {
            return;
        }
        Inventory playerGui = this.playerGuis.get(player.getUniqueId());
        if (!clickedInventory.equals(playerGui)) {
            return;
        }
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        if (slot >= 45) {
            this.handleBottomPanelClick(player, slot);
            return;
        }
        if (item.getType() == Material.PLAYER_HEAD || item.getType() == Material.SKELETON_SKULL) {
            this.handleFriendClick(player, item, event.isRightClick(), event.isShiftClick());
        }
    }

    private void handleBottomPanelClick(Player player, int slot) {
        switch (slot) {
            case 45: {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                break;
            }
            case 49: {
                player.closeInventory();
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (player.isOnline()) {
                        this.openFriendList(player);
                    }
                }, 2L);
                break;
            }
            case 53: {
                player.closeInventory();
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 0.5f);
            }
        }
    }

    private void handleFriendClick(Player player, ItemStack item, boolean isRightClick, boolean isShiftClick) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        String displayName = meta.getDisplayName();
        String friendName = displayName.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
        if (friendName.isEmpty()) {
            return;
        }
        if (isShiftClick && !isRightClick && this.isMessagesAllowed()) {
            player.closeInventory();
            this.pendingMessages.put(player.getUniqueId(), friendName);
            player.sendMessage(ColorUtils.colorize("&b\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0434\u043b\u044f &3" + friendName + "&b:"));
            player.sendMessage(ColorUtils.colorize("&7\u041d\u0430\u043f\u0438\u0448\u0438\u0442\u0435 \u0432 \u0447\u0430\u0442 \u0438\u043b\u0438 '&c\u043e\u0442\u043c\u0435\u043d\u0430&7' \u0434\u043b\u044f \u043e\u0442\u043c\u0435\u043d\u044b"));
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_HARP, 1.0f, 1.5f);
            return;
        }
        if (isRightClick) {
            this.plugin.getFriendManager().removeFriendship(player.getUniqueId(), Bukkit.getOfflinePlayer((String)friendName).getUniqueId());
            player.sendMessage(ColorUtils.colorize("&a\u0418\u0433\u0440\u043e\u043a &2" + friendName + " &a\u0443\u0434\u0430\u043b\u0435\u043d \u0438\u0437 \u0434\u0440\u0443\u0437\u0435\u0439"));
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            player.closeInventory();
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (player.isOnline()) {
                    this.openFriendList(player);
                }
            }, 2L);
        } else if (this.isTeleportAllowed()) {
            Player friend = Bukkit.getPlayerExact((String)friendName);
            if (friend != null && friend.isOnline()) {
                player.closeInventory();
                player.teleport(friend.getLocation());
                player.sendMessage(ColorUtils.colorize("&a\u0422\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a &2" + friendName));
                player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            } else {
                player.sendMessage(ColorUtils.colorize("&c\u0418\u0433\u0440\u043e\u043a &4" + friendName + " &c\u043d\u0435 \u0432 \u0441\u0435\u0442\u0438"));
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
            }
        }
    }

    public void handlePlayerChat(Player player, String message) {
        if (this.pendingMessages.containsKey(player.getUniqueId())) {
            String friendName = this.pendingMessages.remove(player.getUniqueId());
            if (message.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430") || message.equalsIgnoreCase("cancel")) {
                player.sendMessage(ColorUtils.colorize("&c\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430"));
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
                return;
            }
            Player friend = Bukkit.getPlayerExact((String)friendName);
            if (friend != null && friend.isOnline()) {
                friend.sendMessage(ColorUtils.colorize("&3[MSG] \u041e\u0442 &b" + player.getName() + "&3: &f" + message));
                player.sendMessage(ColorUtils.colorize("&3[MSG] \u041a &b" + friendName + "&3: &f" + message));
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
            } else {
                player.sendMessage(ColorUtils.colorize("&c\u0418\u0433\u0440\u043e\u043a &4" + friendName + " &c\u043d\u0435 \u0432 \u0441\u0435\u0442\u0438"));
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (this.playerGuis.containsKey(player.getUniqueId()) && event.getInventory().equals(this.playerGuis.get(player.getUniqueId()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        this.playerGuis.remove(player.getUniqueId());
    }

    public void cleanupPlayerData(Player player) {
        this.playerGuis.remove(player.getUniqueId());
        this.pendingMessages.remove(player.getUniqueId());
    }
}

