/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.Inffriends.listener;

import com.masterok.Inffriends.InfFriends;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class FriendListener
implements Listener {
    private final InfFriends plugin;

    public FriendListener(InfFriends plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        if (!this.plugin.getConfigManager().isPvpProtectionEnabled()) {
            return;
        }
        if (!(event.getDamager() instanceof Player) || !(event.getEntity() instanceof Player)) {
            return;
        }
        Player damager = (Player)event.getDamager();
        Player target = (Player)event.getEntity();
        if (this.plugin.getFriendManager().areFriends(damager, target)) {
            event.setCancelled(true);
            damager.sendMessage("\u00a7c\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0430\u0442\u0430\u043a\u043e\u0432\u0430\u0442\u044c \u0441\u0432\u043e\u0435\u0433\u043e \u0434\u0440\u0443\u0433\u0430 \u00a7e" + target.getName() + "\u00a7c!");
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.plugin.getFriendManager().sendJoinNotification(player);
        this.plugin.getRequestManager().removeRequest(player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.plugin.getFriendManager().sendLeaveNotification(player);
        this.plugin.getRequestManager().removeRequest(player);
        this.plugin.getFriendGUI().cleanupPlayerData(player);
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (this.plugin.getFriendGUI() != null && this.plugin.getFriendGUI().hasPendingMessage(player)) {
            event.getPlayer().getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getFriendGUI().handlePlayerChat(player, message));
            event.setCancelled(true);
        }
    }
}

