/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.Inffriends.manager;

import com.masterok.Inffriends.InfFriends;
import com.masterok.Inffriends.util.MessageUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class FriendManager {
    private final InfFriends plugin;
    private final Map<UUID, Set<UUID>> friendsMap;
    private File dataFile;
    private FileConfiguration dataConfig;

    public FriendManager(InfFriends plugin) {
        this.plugin = plugin;
        this.friendsMap = new HashMap<UUID, Set<UUID>>();
        this.setupDataFile();
    }

    private void setupDataFile() {
        this.dataFile = new File(this.plugin.getDataFolder(), "friends.yml");
        if (!this.dataFile.exists()) {
            this.plugin.getDataFolder().mkdirs();
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create friends.yml file!");
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    public void loadData() {
        try {
            for (String key : this.dataConfig.getKeys(false)) {
                UUID playerUUID = UUID.fromString(key);
                List friendUUIDs = this.dataConfig.getStringList(key);
                HashSet<UUID> friends = new HashSet<UUID>();
                for (String friendUUID : friendUUIDs) {
                    try {
                        friends.add(UUID.fromString(friendUUID));
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getLogger().warning("Invalid UUID in friends data: " + friendUUID);
                    }
                }
                this.friendsMap.put(playerUUID, friends);
            }
            this.plugin.getLogger().info("Loaded friends data for " + this.friendsMap.size() + " players");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading friends data: " + e.getMessage());
        }
    }

    public void saveData() {
        try {
            for (String string : this.dataConfig.getKeys(false)) {
                this.dataConfig.set(string, null);
            }
            for (Map.Entry entry : this.friendsMap.entrySet()) {
                ArrayList<String> friendUUIDs = new ArrayList<String>();
                for (UUID friendUUID : (Set)entry.getValue()) {
                    friendUUIDs.add(friendUUID.toString());
                }
                this.dataConfig.set(((UUID)entry.getKey()).toString(), friendUUIDs);
            }
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save friends.yml file: " + e.getMessage());
        }
    }

    public boolean areFriends(Player player1, Player player2) {
        if (player1 == null || player2 == null) {
            return false;
        }
        Set<UUID> player1Friends = this.friendsMap.get(player1.getUniqueId());
        Set<UUID> player2Friends = this.friendsMap.get(player2.getUniqueId());
        return player1Friends != null && player1Friends.contains(player2.getUniqueId()) || player2Friends != null && player2Friends.contains(player1.getUniqueId());
    }

    public boolean canAddFriend(UUID playerUUID) {
        int maxFriends = this.plugin.getConfigManager().getMaxFriends();
        if (maxFriends <= 0) {
            return true;
        }
        Set<UUID> friends = this.friendsMap.get(playerUUID);
        return friends == null || friends.size() < maxFriends;
    }

    public void addFriendship(UUID player1UUID, UUID player2UUID) {
        this.friendsMap.computeIfAbsent(player1UUID, k -> new HashSet()).add(player2UUID);
        this.friendsMap.computeIfAbsent(player2UUID, k -> new HashSet()).add(player1UUID);
        this.saveData();
    }

    public void removeFriendship(UUID player1UUID, UUID player2UUID) {
        this.removeOneWay(player1UUID, player2UUID);
        this.removeOneWay(player2UUID, player1UUID);
        this.saveData();
    }

    private void removeOneWay(UUID fromUUID, UUID toUUID) {
        Set<UUID> friends = this.friendsMap.get(fromUUID);
        if (friends != null) {
            friends.remove(toUUID);
            if (friends.isEmpty()) {
                this.friendsMap.remove(fromUUID);
            }
        }
    }

    public Set<UUID> getFriends(UUID playerUUID) {
        return this.friendsMap.getOrDefault(playerUUID, Collections.emptySet());
    }

    public List<String> getFriendNames(UUID playerUUID) {
        ArrayList<String> friendNames = new ArrayList<String>();
        Set<UUID> friends = this.getFriends(playerUUID);
        for (UUID friendUUID : friends) {
            String name = Bukkit.getOfflinePlayer((UUID)friendUUID).getName();
            if (name == null) continue;
            friendNames.add(name);
        }
        return friendNames;
    }

    public List<Player> getOnlineFriends(UUID playerUUID) {
        ArrayList<Player> onlineFriends = new ArrayList<Player>();
        Set<UUID> friends = this.getFriends(playerUUID);
        for (UUID friendUUID : friends) {
            Player friend = Bukkit.getPlayer((UUID)friendUUID);
            if (friend == null || !friend.isOnline()) continue;
            onlineFriends.add(friend);
        }
        return onlineFriends;
    }

    public boolean isFriend(UUID playerUUID, UUID friendUUID) {
        Set<UUID> friends = this.friendsMap.get(playerUUID);
        return friends != null && friends.contains(friendUUID);
    }

    public void sendJoinNotification(Player joinedPlayer) {
        if (!this.plugin.getConfigManager().areJoinLeaveNotificationsEnabled()) {
            return;
        }
        for (UUID friendUUID : this.getFriends(joinedPlayer.getUniqueId())) {
            Player friend = Bukkit.getPlayer((UUID)friendUUID);
            if (friend == null || !friend.isOnline()) continue;
            MessageUtils.sendMessage((CommandSender)friend, "info.join-notification", "player", joinedPlayer.getName());
        }
    }

    public void sendLeaveNotification(Player leftPlayer) {
        if (!this.plugin.getConfigManager().areJoinLeaveNotificationsEnabled()) {
            return;
        }
        for (UUID friendUUID : this.getFriends(leftPlayer.getUniqueId())) {
            Player friend = Bukkit.getPlayer((UUID)friendUUID);
            if (friend == null || !friend.isOnline()) continue;
            MessageUtils.sendMessage((CommandSender)friend, "info.leave-notification", "player", leftPlayer.getName());
        }
    }
}

