/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.Inffriends;

import com.masterok.Inffriends.command.FriendCommand;
import com.masterok.Inffriends.gui.FriendGUI;
import com.masterok.Inffriends.listener.FriendListener;
import com.masterok.Inffriends.manager.ConfigManager;
import com.masterok.Inffriends.manager.FriendManager;
import com.masterok.Inffriends.manager.FriendRequestManager;
import com.masterok.Inffriends.util.UpdateChecker;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class InfFriends
extends JavaPlugin {
    private static InfFriends instance;
    private ConfigManager configManager;
    private FriendManager friendManager;
    private FriendRequestManager requestManager;
    private FriendGUI friendGUI;
    private UpdateChecker updateChecker;

    public void onEnable() {
        instance = this;
        this.getLogger().info("=== InfFriends Plugin Starting ===");
        try {
            this.getLogger().info("Initializing managers...");
            this.configManager = new ConfigManager(this);
            this.friendManager = new FriendManager(this);
            this.requestManager = new FriendRequestManager(this);
            this.getLogger().info("Loading configurations...");
            this.configManager.loadConfigs();
            this.getLogger().info("Initializing GUI...");
            this.friendGUI = new FriendGUI(this);
            this.getLogger().info("Registering commands...");
            this.getCommand("friend").setExecutor((CommandExecutor)new FriendCommand(this));
            this.getLogger().info("Registering listeners...");
            this.getServer().getPluginManager().registerEvents((Listener)new FriendListener(this), (Plugin)this);
            this.getLogger().info("Loading friend data...");
            this.friendManager.loadData();
            this.getLogger().info("Checking for updates...");
            this.updateChecker = new UpdateChecker(this);
            this.updateChecker.checkForUpdates();
            this.getLogger().info("=== InfFriends Plugin Enabled Successfully! ===");
        }
        catch (Exception e) {
            this.getLogger().severe("=== FAILED TO ENABLE InfFriends PLUGIN ===");
            this.getLogger().severe("Error: " + e.getMessage());
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        this.getLogger().info("=== InfFriends Plugin Disabling ===");
        if (this.friendManager != null) {
            this.getLogger().info("Saving friend data...");
            this.friendManager.saveData();
        }
        this.getLogger().info("=== InfFriends Plugin Disabled ===");
    }

    public static InfFriends getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public FriendManager getFriendManager() {
        return this.friendManager;
    }

    public FriendRequestManager getRequestManager() {
        return this.requestManager;
    }

    public FriendGUI getFriendGUI() {
        return this.friendGUI;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }
}

