/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.Inffriends.command;

import com.masterok.Inffriends.InfFriends;
import com.masterok.Inffriends.gui.FriendGUI;
import com.masterok.Inffriends.util.ColorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class FriendCommand
implements CommandExecutor,
TabCompleter {
    private final InfFriends plugin;
    private final FriendGUI friendGUI;

    public FriendCommand(InfFriends plugin) {
        this.plugin = plugin;
        this.friendGUI = plugin.getFriendGUI();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, "&c\u2613 \u042d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443 \u043c\u043e\u0433\u0443\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u0438!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelp(player);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "add": {
                this.handleAdd(player, args);
                break;
            }
            case "remove": {
                this.handleRemove(player, args);
                break;
            }
            case "list": {
                this.handleList(player);
                break;
            }
            case "accept": {
                this.handleAccept(player);
                break;
            }
            case "deny": {
                this.handleDeny(player);
                break;
            }
            case "menu": 
            case "gui": {
                this.handleMenu(player);
                break;
            }
            case "msg": 
            case "message": 
            case "m": 
            case "tell": {
                this.handleMessage(player, args);
                break;
            }
            case "sit": 
            case "ride": {
                this.handleSit(player, args);
                break;
            }
            case "reload": {
                this.handleReload(player);
                break;
            }
            case "help": {
                this.sendHelp(player);
                break;
            }
            default: {
                this.sendHelp(player);
            }
        }
        return true;
    }

    private void sendMessage(CommandSender sender, String message) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            player.sendMessage(ColorUtils.colorize(message));
        } else {
            sender.sendMessage(ColorUtils.colorize(message));
        }
    }

    private void sendHelp(Player player) {
        player.sendMessage(ColorUtils.colorize("&6\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac"));
        player.sendMessage(ColorUtils.colorize("&e               \u2726 &6InfFriends &e\u2726"));
        player.sendMessage(ColorUtils.colorize("&6\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac"));
        player.sendMessage("");
        ArrayList<String[]> commands = new ArrayList<String[]>();
        commands.add(new String[]{"add <\u0438\u0433\u0440\u043e\u043a>", "&a\u2713 &a\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f"});
        commands.add(new String[]{"remove <\u0438\u0433\u0440\u043e\u043a>", "&c\u2613 &c\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0437 \u0434\u0440\u0443\u0437\u0435\u0439"});
        commands.add(new String[]{"list", "&b\u2261 &b\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0434\u0440\u0443\u0437\u0435\u0439"});
        commands.add(new String[]{"accept", "&a\u2713 &a\u041f\u0440\u0438\u043d\u044f\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f"});
        commands.add(new String[]{"deny", "&c\u2613 &c\u041e\u0442\u043a\u043b\u043e\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f"});
        commands.add(new String[]{"menu", "&e\u2630 &e\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u043c\u0435\u043d\u044e \u0434\u0440\u0443\u0437\u0435\u0439"});
        commands.add(new String[]{"msg <\u0438\u0433\u0440\u043e\u043a> <\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435>", "&b\u2709 &b\u041d\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u043b\u0438\u0447\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435"});
        if (this.plugin.getConfigManager().isSitEnabled()) {
            commands.add(new String[]{"sit <\u0438\u0433\u0440\u043e\u043a>", "&e\u2658 &e\u0421\u0435\u0441\u0442\u044c \u043d\u0430 \u0433\u043e\u043b\u043e\u0432\u0443 \u0434\u0440\u0443\u0433\u0430"});
        }
        commands.add(new String[]{"help", "&e? &e\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u044d\u0442\u0443 \u043f\u043e\u043c\u043e\u0449\u044c"});
        for (String[] cmd : commands) {
            player.sendMessage(ColorUtils.colorize("&a/f " + cmd[0] + " &7- " + cmd[1]));
        }
        if (player.hasPermission("inffriends.admin")) {
            player.sendMessage(ColorUtils.colorize("&a/f reload &7- &e\u2699 &e\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e"));
        }
        player.sendMessage("");
        player.sendMessage(ColorUtils.colorize("&7\u25cf &7\u0410\u043b\u0438\u0430\u0441\u044b: &f/friends&7, &f/\u0434\u0440"));
        player.sendMessage(ColorUtils.colorize("&7\u25cf &7\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f: &f/f msg&7, &f/f m&7, &f/f tell"));
        if (this.plugin.getConfigManager().isSitEnabled()) {
            player.sendMessage(ColorUtils.colorize("&7\u25cf &7\u0421\u0438\u0434\u0435\u0442\u044c: &f/f sit&7, &f/f ride"));
        }
        player.sendMessage(ColorUtils.colorize("&6\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac"));
    }

    private void handleAdd(Player player, String[] args) {
        if (args.length < 2) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: &f/f add <\u0438\u0433\u0440\u043e\u043a>");
            return;
        }
        String targetName = args[1];
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0418\u0433\u0440\u043e\u043a &4" + targetName + " &c\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
            return;
        }
        if (target == player) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u0435\u0431\u044f \u0432 \u0434\u0440\u0443\u0437\u044c\u044f!");
            return;
        }
        if (this.plugin.getFriendManager().areFriends(player, target)) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0418\u0433\u0440\u043e\u043a &4" + target.getName() + " &c\u0443\u0436\u0435 \u0432 \u0432\u0430\u0448\u0435\u043c \u0441\u043f\u0438\u0441\u043a\u0435 \u0434\u0440\u0443\u0437\u0435\u0439!");
            return;
        }
        this.plugin.getRequestManager().sendRequest(player, target);
    }

    private void handleRemove(Player player, String[] args) {
        if (args.length < 2) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: &f/f remove <\u0438\u0433\u0440\u043e\u043a>");
            return;
        }
        String targetName = args[1];
        Player target = Bukkit.getPlayer((String)targetName);
        if (target != null) {
            this.removeOnlineFriend(player, target);
            return;
        }
        this.removeOfflineFriend(player, targetName);
    }

    private void removeOnlineFriend(Player player, Player target) {
        if (!this.plugin.getFriendManager().areFriends(player, target)) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0418\u0433\u0440\u043e\u043a &4" + target.getName() + " &c\u043d\u0435 \u0432 \u0432\u0430\u0448\u0435\u043c \u0441\u043f\u0438\u0441\u043a\u0435 \u0434\u0440\u0443\u0437\u0435\u0439!");
            return;
        }
        this.plugin.getFriendManager().removeFriendship(player.getUniqueId(), target.getUniqueId());
        this.sendMessage((CommandSender)player, "&a\u2713 \u0418\u0433\u0440\u043e\u043a &2" + target.getName() + " &a\u0443\u0434\u0430\u043b\u0435\u043d \u0438\u0437 \u0434\u0440\u0443\u0437\u0435\u0439!");
    }

    private void removeOfflineFriend(Player player, String targetName) {
        boolean removed = false;
        UUID playerUUID = player.getUniqueId();
        for (UUID friendUUID : this.plugin.getFriendManager().getFriends(playerUUID)) {
            String friendName = Bukkit.getOfflinePlayer((UUID)friendUUID).getName();
            if (friendName == null || !friendName.equalsIgnoreCase(targetName)) continue;
            this.plugin.getFriendManager().removeFriendship(playerUUID, friendUUID);
            this.sendMessage((CommandSender)player, "&a\u2713 \u0418\u0433\u0440\u043e\u043a &2" + targetName + " &a\u0443\u0434\u0430\u043b\u0435\u043d \u0438\u0437 \u0434\u0440\u0443\u0437\u0435\u0439!");
            removed = true;
            break;
        }
        if (!removed) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0418\u0433\u0440\u043e\u043a &4" + targetName + " &c\u043d\u0435 \u0432 \u0432\u0430\u0448\u0435\u043c \u0441\u043f\u0438\u0441\u043a\u0435 \u0434\u0440\u0443\u0437\u0435\u0439!");
        }
    }

    private void handleList(Player player) {
        List<String> friendNames = this.plugin.getFriendManager().getFriendNames(player.getUniqueId());
        if (friendNames.isEmpty()) {
            this.sendMessage((CommandSender)player, "&e\u2261 \u0423 \u0432\u0430\u0441 \u043f\u043e\u043a\u0430 \u043d\u0435\u0442 \u0434\u0440\u0443\u0437\u0435\u0439!");
            this.sendMessage((CommandSender)player, "&7\u25cf \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 &f/f add <\u0438\u0433\u0440\u043e\u043a> &7\u0447\u0442\u043e\u0431\u044b \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0434\u0440\u0443\u0433\u0430");
            return;
        }
        List<Player> onlineFriends = this.plugin.getFriendManager().getOnlineFriends(player.getUniqueId());
        player.sendMessage(ColorUtils.colorize("&6\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac"));
        player.sendMessage(ColorUtils.colorize("&e               \u2726 &6\u0412\u0430\u0448\u0438 \u0434\u0440\u0443\u0437\u044c\u044f &e\u2726"));
        player.sendMessage(ColorUtils.colorize("&a\u25cf \u0412\u0441\u0435\u0433\u043e: &2" + friendNames.size() + " &a| &2\u25cf \u041e\u043d\u043b\u0430\u0439\u043d: &2" + onlineFriends.size()));
        player.sendMessage(ColorUtils.colorize("&6\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac"));
        for (String friendName : friendNames) {
            Player friend = Bukkit.getPlayer((String)friendName);
            if (friend != null && friend.isOnline()) {
                player.sendMessage(ColorUtils.colorize("  &a\u2713 &a" + friendName + " &2\u25cf \u043e\u043d\u043b\u0430\u0439\u043d"));
                continue;
            }
            player.sendMessage(ColorUtils.colorize("  &7\u2613 &7" + friendName + " &8\u25cf \u043e\u0444\u0444\u043b\u0430\u0439\u043d"));
        }
        player.sendMessage(ColorUtils.colorize("&6\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac"));
    }

    private void handleAccept(Player player) {
        if (!this.plugin.getRequestManager().hasPendingRequest(player)) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043e\u0436\u0438\u0434\u0430\u044e\u0449\u0438\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f!");
            return;
        }
        this.plugin.getRequestManager().acceptRequest(player);
    }

    private void handleDeny(Player player) {
        if (!this.plugin.getRequestManager().hasPendingRequest(player)) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043e\u0436\u0438\u0434\u0430\u044e\u0449\u0438\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f!");
            return;
        }
        this.plugin.getRequestManager().denyRequest(player);
    }

    private void handleMenu(Player player) {
        try {
            if (!this.plugin.getConfigManager().getConfig().getBoolean("gui.enabled", true)) {
                this.sendMessage((CommandSender)player, "&c\u2613 \u041c\u0435\u043d\u044e \u0434\u0440\u0443\u0437\u0435\u0439 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0433\u0438\u043d\u0430!");
                return;
            }
            this.sendMessage((CommandSender)player, "&a\u2630 \u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u043c\u0435\u043d\u044e \u0434\u0440\u0443\u0437\u0435\u0439...");
            this.friendGUI.openFriendList(player);
        }
        catch (Exception e) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0438 \u043c\u0435\u043d\u044e \u0434\u0440\u0443\u0437\u0435\u0439!");
            this.plugin.getLogger().severe("Menu error for " + player.getName() + ": " + e.getMessage());
        }
    }

    private void handleMessage(Player player, String[] args) {
        if (args.length < 3) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: &f/f msg <\u0438\u0433\u0440\u043e\u043a> <\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435>");
            this.sendMessage((CommandSender)player, "&7\u25cf \u0410\u043b\u0438\u0430\u0441\u044b: &f/f message&7, &f/f m&7, &f/f tell");
            return;
        }
        String targetName = args[1];
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0418\u0433\u0440\u043e\u043a &4" + targetName + " &c\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u043d\u0435 \u0432 \u0441\u0435\u0442\u0438!");
            return;
        }
        if (!this.plugin.getFriendManager().areFriends(player, target)) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u0438\u0441\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0441\u0432\u043e\u0438\u043c \u0434\u0440\u0443\u0437\u044c\u044f\u043c!");
            return;
        }
        StringBuilder messageBuilder = new StringBuilder();
        for (int i = 2; i < args.length; ++i) {
            messageBuilder.append(args[i]).append(" ");
        }
        String message = messageBuilder.toString().trim();
        target.sendMessage(ColorUtils.colorize("&b\u2709 \u041e\u0442 &3" + player.getName() + "&b: &f" + message));
        player.sendMessage(ColorUtils.colorize("&b\u2709 \u041a &3" + targetName + "&b: &f" + message));
        target.playSound(target.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
    }

    private void handleSit(Player player, String[] args) {
        if (!this.plugin.getConfigManager().isSitEnabled()) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0441\u0438\u0434\u0435\u043d\u0438\u044f \u043d\u0430 \u0433\u043e\u043b\u043e\u0432\u0430\u0445 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0433\u0438\u043d\u0430!");
            return;
        }
        if (args.length < 2) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: &f/f sit <\u0438\u0433\u0440\u043e\u043a>");
            this.sendMessage((CommandSender)player, "&7\u25cf \u0410\u043b\u0438\u0430\u0441: &f/f ride");
            return;
        }
        String targetName = args[1];
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0418\u0433\u0440\u043e\u043a &4" + targetName + " &c\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u043d\u0435 \u0432 \u0441\u0435\u0442\u0438!");
            return;
        }
        if (!this.plugin.getFriendManager().areFriends(player, target)) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0441\u0438\u0434\u0435\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0433\u043e\u043b\u043e\u0432\u0430\u0445 \u0441\u0432\u043e\u0438\u0445 \u0434\u0440\u0443\u0437\u0435\u0439!");
            return;
        }
        if (player == target) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0441\u0438\u0434\u0435\u0442\u044c \u043d\u0430 \u0441\u0432\u043e\u0435\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0433\u043e\u043b\u043e\u0432\u0435!");
            return;
        }
        if (player.getLocation().distance(target.getLocation()) > 10.0) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0418\u0433\u0440\u043e\u043a \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u0430\u043b\u0435\u043a\u043e! \u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0440\u0430\u0441\u0441\u0442\u043e\u044f\u043d\u0438\u0435: 10 \u0431\u043b\u043e\u043a\u043e\u0432");
            return;
        }
        boolean success = this.sitOnHead(player, target);
        if (success) {
            this.sendMessage((CommandSender)player, "&a\u2658 \u0412\u044b \u0441\u0435\u043b\u0438 \u043d\u0430 \u0433\u043e\u043b\u043e\u0432\u0443 &2" + target.getName() + "&a!");
            this.sendMessage((CommandSender)target, "&a\u2658 \u0418\u0433\u0440\u043e\u043a &2" + player.getName() + " &a\u0441\u0435\u043b \u043d\u0430 \u0432\u0430\u0448\u0443 \u0433\u043e\u043b\u043e\u0432\u0443!");
        } else {
            this.sendMessage((CommandSender)player, "&c\u2613 \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0435\u0441\u0442\u044c \u043d\u0430 \u0433\u043e\u043b\u043e\u0432\u0443 \u0438\u0433\u0440\u043e\u043a\u0430!");
        }
    }

    private boolean sitOnHead(Player rider, Player target) {
        try {
            Location headLocation = target.getLocation().add(0.0, 2.0, 0.0);
            rider.teleport(headLocation);
            target.addPassenger((Entity)rider);
            rider.playSound(rider.getLocation(), Sound.ENTITY_PARROT_IMITATE_ENDER_DRAGON, 1.0f, 1.5f);
            target.playSound(target.getLocation(), Sound.ENTITY_PARROT_IMITATE_ENDER_DRAGON, 1.0f, 1.5f);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error sitting on head: " + e.getMessage());
            return false;
        }
    }

    private void handleReload(Player player) {
        if (!player.hasPermission("inffriends.admin")) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!");
            return;
        }
        try {
            this.plugin.getConfigManager().reloadConfigs();
            this.sendMessage((CommandSender)player, "&a\u2713 \u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430!");
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
        }
        catch (Exception e) {
            this.sendMessage((CommandSender)player, "&c\u2613 \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438!");
            this.plugin.getLogger().severe("Reload error: " + e.getMessage());
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block7: {
            String current;
            String subCommand;
            Player player;
            block8: {
                block6: {
                    completions = new ArrayList<String>();
                    if (!(sender instanceof Player)) {
                        return completions;
                    }
                    player = (Player)sender;
                    if (args.length != 1) break block6;
                    ArrayList<String> options = new ArrayList<String>();
                    options.add("add");
                    options.add("remove");
                    options.add("list");
                    options.add("accept");
                    options.add("deny");
                    options.add("menu");
                    options.add("msg");
                    if (this.plugin.getConfigManager().isSitEnabled()) {
                        options.add("sit");
                    }
                    options.add("help");
                    if (player.hasPermission("inffriends.admin")) {
                        options.add("reload");
                    }
                    String current2 = args[0].toLowerCase();
                    for (String option : options) {
                        if (!option.startsWith(current2)) continue;
                        completions.add(option);
                    }
                    break block7;
                }
                if (args.length != 2) break block7;
                subCommand = args[0].toLowerCase();
                current = args[1].toLowerCase();
                if (!subCommand.equals("add")) break block8;
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    if (onlinePlayer.equals(player) || this.plugin.getFriendManager().areFriends(player, onlinePlayer) || !onlinePlayer.getName().toLowerCase().startsWith(current)) continue;
                    completions.add(onlinePlayer.getName());
                }
                break block7;
            }
            if (!subCommand.equals("remove") && !subCommand.equals("msg") && (!subCommand.equals("sit") || !this.plugin.getConfigManager().isSitEnabled())) break block7;
            for (String friendName : this.plugin.getFriendManager().getFriendNames(player.getUniqueId())) {
                if (!friendName.toLowerCase().startsWith(current)) continue;
                completions.add(friendName);
            }
        }
        return completions;
    }
}

