/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.Inffriends.gui;

import com.masterok.Inffriends.InfFriends;
import com.masterok.Inffriends.util.ColorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class FriendGUI
implements Listener {
    private final InfFriends plugin;
    private final Map<UUID, Inventory> playerGuis;
    private final Map<UUID, String> pendingMessages;
    private boolean oraxenEnabled = false;

    public FriendGUI(InfFriends plugin) {
        this.plugin = plugin;
        this.playerGuis = new HashMap<UUID, Inventory>();
        this.pendingMessages = new HashMap<UUID, String>();
        try {
            Class.forName("io.th0rgal.oraxen.api.OraxenItems");
            this.oraxenEnabled = true;
            plugin.getLogger().info("Oraxen \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d! \u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430 Oraxen \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432.");
        }
        catch (ClassNotFoundException e) {
            this.oraxenEnabled = false;
            plugin.getLogger().info("Oraxen \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0442\u0441\u044f \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b.");
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean isGuiEnabled() {
        return this.plugin.getConfigManager().isGuiEnabled();
    }

    public boolean isTeleportAllowed() {
        return this.plugin.getConfigManager().isTeleportAllowed();
    }

    public boolean isMessagesAllowed() {
        return this.plugin.getConfigManager().isMessagesAllowed();
    }

    public boolean hasPendingMessage(Player player) {
        return this.pendingMessages.containsKey(player.getUniqueId());
    }

    public void openFriendList(Player player) {
        if (!this.isGuiEnabled()) {
            ColorUtils.sendMessage((CommandSender)player, "&c\u2613 GUI \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0433\u0438\u043d\u0430");
            return;
        }
        try {
            Player friend;
            if (player.getOpenInventory() != null && this.playerGuis.containsKey(player.getUniqueId())) {
                player.closeInventory();
            }
            List<String> friendNames = this.plugin.getFriendManager().getFriendNames(player.getUniqueId());
            List<Player> onlineFriends = this.plugin.getFriendManager().getOnlineFriends(player.getUniqueId());
            int guiSize = this.plugin.getConfigManager().getGuiSize();
            String guiTitle = ColorUtils.colorize(this.plugin.getConfigManager().getGuiTitle());
            Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)guiSize, (String)guiTitle);
            this.playerGuis.put(player.getUniqueId(), gui);
            int slot = 0;
            for (String friendName : friendNames) {
                friend = Bukkit.getPlayer((String)friendName);
                if (friend == null || !friend.isOnline()) continue;
                if (slot >= 45) break;
                gui.setItem(slot, this.createOnlineFriendItem(friend));
                ++slot;
            }
            for (String friendName : friendNames) {
                friend = Bukkit.getPlayer((String)friendName);
                if (friend != null && friend.isOnline()) continue;
                if (slot >= 45) break;
                gui.setItem(slot, this.createOfflineFriendItem(friendName));
                ++slot;
            }
            this.addBottomPanel(gui, player, onlineFriends.size(), friendNames.size());
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (player.isOnline()) {
                    player.openInventory(gui);
                }
            }, 1L);
        }
        catch (Exception e) {
            ColorUtils.sendMessage((CommandSender)player, "&c\u2613 \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0438 GUI");
            this.plugin.getLogger().severe("Error opening GUI: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private ItemStack createOnlineFriendItem(Player friend) {
        ItemStack item;
        ItemMeta meta;
        String materialName;
        Material material;
        String oraxenId = this.plugin.getConfigManager().getOraxenId("online-friend");
        if (this.oraxenEnabled && !oraxenId.isEmpty()) {
            try {
                Object oraxenItem = Class.forName("io.th0rgal.oraxen.api.OraxenItems").getMethod("getItemById", String.class).invoke(null, oraxenId);
                if (oraxenItem != null) {
                    ItemStack item2 = (ItemStack)oraxenItem;
                    this.setupOnlineFriendMeta(item2.getItemMeta(), friend);
                    return item2;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c Oraxen \u043f\u0440\u0435\u0434\u043c\u0435\u0442: " + oraxenId);
            }
        }
        if ((material = Material.getMaterial((String)(materialName = this.plugin.getConfigManager().getItemMaterial("online-friend")))) == null) {
            material = Material.PLAYER_HEAD;
        }
        if ((meta = (item = new ItemStack(material)).getItemMeta()) != null) {
            int customModelData = this.plugin.getConfigManager().getCustomModelData("online-friend");
            if (customModelData > 0) {
                try {
                    meta.setCustomModelData(Integer.valueOf(customModelData));
                }
                catch (NoSuchMethodError e) {
                    this.plugin.getLogger().warning("CustomModelData \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u044d\u0442\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft");
                }
            }
            this.setupOnlineFriendMeta(meta, friend);
            item.setItemMeta(meta);
            if (material == Material.PLAYER_HEAD && meta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)meta;
                skullMeta.setOwningPlayer((OfflinePlayer)friend);
                item.setItemMeta((ItemMeta)skullMeta);
            }
        }
        return item;
    }

    private void setupOnlineFriendMeta(ItemMeta meta, Player friend) {
        String name = this.plugin.getConfigManager().getGuiItemName("online-friend").replace("{player}", friend.getName());
        meta.setDisplayName(ColorUtils.colorize(name));
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : this.plugin.getConfigManager().getGuiItemLore("online-friend")) {
            if ((line = line.replace("{player}", friend.getName()).replace("{location}", this.getFormattedLocation(friend.getLocation())).replace("{health}", String.format("%.1f", friend.getHealth()))).contains("\u041b\u041a\u041c - \u0422\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f") && !this.isTeleportAllowed() || line.contains("Shift+\u041b\u041a\u041c - \u041d\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435") && !this.isMessagesAllowed() || line.contains("\u041c\u0435\u0441\u0442\u043e\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435") && !this.plugin.getConfigManager().isShowLocationEnabled() || line.contains("\u0417\u0434\u043e\u0440\u043e\u0432\u044c\u0435") && !this.plugin.getConfigManager().isShowHealthEnabled()) continue;
            lore.add(ColorUtils.colorize(line));
        }
        meta.setLore(lore);
    }

    private ItemStack createOfflineFriendItem(String friendName) {
        ItemStack item;
        block12: {
            ItemMeta meta;
            String materialName;
            Material material;
            String oraxenId = this.plugin.getConfigManager().getOraxenId("offline-friend");
            if (this.oraxenEnabled && !oraxenId.isEmpty()) {
                try {
                    Object oraxenItem = Class.forName("io.th0rgal.oraxen.api.OraxenItems").getMethod("getItemById", String.class).invoke(null, oraxenId);
                    if (oraxenItem != null) {
                        ItemStack item2 = (ItemStack)oraxenItem;
                        this.setupOfflineFriendMeta(item2.getItemMeta(), friendName);
                        return item2;
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c Oraxen \u043f\u0440\u0435\u0434\u043c\u0435\u0442: " + oraxenId);
                }
            }
            if ((material = Material.getMaterial((String)(materialName = this.plugin.getConfigManager().getItemMaterial("offline-friend")))) == null) {
                material = Material.PLAYER_HEAD;
            }
            if ((meta = (item = new ItemStack(material)).getItemMeta()) != null) {
                int customModelData = this.plugin.getConfigManager().getCustomModelData("offline-friend");
                if (customModelData > 0) {
                    try {
                        meta.setCustomModelData(Integer.valueOf(customModelData));
                    }
                    catch (NoSuchMethodError e) {
                        this.plugin.getLogger().warning("CustomModelData \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u044d\u0442\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft");
                    }
                }
                this.setupOfflineFriendMeta(meta, friendName);
                item.setItemMeta(meta);
                if (material == Material.PLAYER_HEAD && meta instanceof SkullMeta) {
                    SkullMeta skullMeta = (SkullMeta)meta;
                    try {
                        skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)friendName));
                    }
                    catch (Exception e) {
                        item.setType(Material.SKELETON_SKULL);
                        meta = item.getItemMeta();
                        if (meta == null) break block12;
                        this.setupOfflineFriendMeta(meta, friendName);
                        item.setItemMeta(meta);
                    }
                }
            }
        }
        return item;
    }

    private void setupOfflineFriendMeta(ItemMeta meta, String friendName) {
        String name = this.plugin.getConfigManager().getGuiItemName("offline-friend").replace("{player}", friendName);
        meta.setDisplayName(ColorUtils.colorize(name));
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : this.plugin.getConfigManager().getGuiItemLore("offline-friend")) {
            line = line.replace("{player}", friendName).replace("{last-seen}", this.getLastSeen(friendName));
            lore.add(ColorUtils.colorize(line));
        }
        meta.setLore(lore);
    }

    private String getFormattedLocation(Location loc) {
        return String.format("X: %d, Y: %d, Z: %d", loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    private String getLastSeen(String playerName) {
        try {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
            if (offlinePlayer == null) {
                return "\u041d\u0438\u043a\u043e\u0433\u0434\u0430";
            }
            long lastPlayed = offlinePlayer.getLastPlayed();
            if (lastPlayed == 0L) {
                return "\u041d\u0438\u043a\u043e\u0433\u0434\u0430";
            }
            if (offlinePlayer.isOnline()) {
                return "\u0421\u0435\u0439\u0447\u0430\u0441 \u043e\u043d\u043b\u0430\u0439\u043d";
            }
            long currentTime = System.currentTimeMillis();
            long timeDiff = currentTime - lastPlayed;
            return this.formatTimeDifference(timeDiff);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0432\u0445\u043e\u0434\u0430 \u0434\u043b\u044f " + playerName + ": " + e.getMessage());
            return "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e";
        }
    }

    private String formatTimeDifference(long timeDiff) {
        long seconds = timeDiff / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        long weeks = days / 7L;
        long months = days / 30L;
        long years = days / 365L;
        if (years > 0L) {
            return years + " " + this.pluralize(years, "\u0433\u043e\u0434", "\u0433\u043e\u0434\u0430", "\u043b\u0435\u0442");
        }
        if (months > 0L) {
            return months + " " + this.pluralize(months, "\u043c\u0435\u0441\u044f\u0446", "\u043c\u0435\u0441\u044f\u0446\u0430", "\u043c\u0435\u0441\u044f\u0446\u0435\u0432");
        }
        if (weeks > 0L) {
            return weeks + " " + this.pluralize(weeks, "\u043d\u0435\u0434\u0435\u043b\u044e", "\u043d\u0435\u0434\u0435\u043b\u0438", "\u043d\u0435\u0434\u0435\u043b\u044c");
        }
        if (days > 0L) {
            return days + " " + this.pluralize(days, "\u0434\u0435\u043d\u044c", "\u0434\u043d\u044f", "\u0434\u043d\u0435\u0439");
        }
        if (hours > 0L) {
            return hours + " " + this.pluralize(hours, "\u0447\u0430\u0441", "\u0447\u0430\u0441\u0430", "\u0447\u0430\u0441\u043e\u0432");
        }
        if (minutes > 0L) {
            return minutes + " " + this.pluralize(minutes, "\u043c\u0438\u043d\u0443\u0442\u0443", "\u043c\u0438\u043d\u0443\u0442\u044b", "\u043c\u0438\u043d\u0443\u0442");
        }
        return "\u041c\u0435\u043d\u0435\u0435 \u043c\u0438\u043d\u0443\u0442\u044b";
    }

    private String pluralize(long number, String one, String two, String five) {
        long n = Math.abs(number);
        if ((n %= 100L) >= 5L && n <= 20L) {
            return five;
        }
        if ((n %= 10L) == 1L) {
            return one;
        }
        if (n >= 2L && n <= 4L) {
            return two;
        }
        return five;
    }

    private void addBottomPanel(Inventory gui, Player player, int onlineCount, int totalCount) {
        HashMap<String, String> infoPlaceholders = new HashMap<String, String>();
        infoPlaceholders.put("{total}", String.valueOf(totalCount));
        infoPlaceholders.put("{online}", String.valueOf(onlineCount));
        infoPlaceholders.put("{offline}", String.valueOf(totalCount - onlineCount));
        infoPlaceholders.put("{teleport-status}", this.isTeleportAllowed() ? "\u2713" : "\u2613");
        infoPlaceholders.put("{messages-status}", this.isMessagesAllowed() ? "\u2713" : "\u2613");
        infoPlaceholders.put("{location-status}", this.plugin.getConfigManager().isShowLocationEnabled() ? "\u2713" : "\u2613");
        infoPlaceholders.put("{health-status}", this.plugin.getConfigManager().isShowHealthEnabled() ? "\u2713" : "\u2613");
        infoPlaceholders.put("{teleport-value}", this.isTeleportAllowed() ? "&a\u0412\u041a\u041b" : "&c\u0412\u042b\u041a\u041b");
        infoPlaceholders.put("{messages-value}", this.isMessagesAllowed() ? "&a\u0412\u041a\u041b" : "&c\u0412\u042b\u041a\u041b");
        infoPlaceholders.put("{location-value}", this.plugin.getConfigManager().isShowLocationEnabled() ? "&a\u0412\u041a\u041b" : "&c\u0412\u042b\u041a\u041b");
        infoPlaceholders.put("{health-value}", this.plugin.getConfigManager().isShowHealthEnabled() ? "&a\u0412\u041a\u041b" : "&c\u0412\u042b\u041a\u041b");
        ItemStack info = this.createGuiItem("info", infoPlaceholders);
        gui.setItem(this.plugin.getConfigManager().getSlot("info"), info);
        ItemStack refresh = this.createGuiItem("refresh", new HashMap<String, String>());
        gui.setItem(this.plugin.getConfigManager().getSlot("refresh"), refresh);
        ItemStack close = this.createGuiItem("close", new HashMap<String, String>());
        gui.setItem(this.plugin.getConfigManager().getSlot("close"), close);
        ItemStack decoration = this.createGuiItem("decoration", new HashMap<String, String>());
        int startSlot = this.plugin.getConfigManager().getSlot("decoration-start");
        int endSlot = this.plugin.getConfigManager().getSlot("decoration-end");
        for (int i = startSlot; i <= endSlot; ++i) {
            if (i == this.plugin.getConfigManager().getSlot("refresh")) continue;
            gui.setItem(i, decoration);
        }
    }

    private ItemStack createGuiItem(String itemType, Map<String, String> placeholders) {
        ItemStack item;
        ItemMeta meta;
        String materialName;
        Material material;
        String oraxenId = this.plugin.getConfigManager().getOraxenId(itemType);
        if (this.oraxenEnabled && !oraxenId.isEmpty()) {
            try {
                Object oraxenItem = Class.forName("io.th0rgal.oraxen.api.OraxenItems").getMethod("getItemById", String.class).invoke(null, oraxenId);
                if (oraxenItem != null) {
                    ItemStack item2 = (ItemStack)oraxenItem;
                    ItemMeta meta2 = item2.getItemMeta();
                    if (meta2 != null) {
                        this.setupItemMeta(meta2, itemType, placeholders);
                        item2.setItemMeta(meta2);
                    }
                    return item2;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c Oraxen \u043f\u0440\u0435\u0434\u043c\u0435\u0442: " + oraxenId);
            }
        }
        if ((material = Material.getMaterial((String)(materialName = this.plugin.getConfigManager().getItemMaterial(itemType)))) == null) {
            material = Material.STONE;
        }
        if ((meta = (item = new ItemStack(material)).getItemMeta()) != null) {
            int customModelData = this.plugin.getConfigManager().getCustomModelData(itemType);
            if (customModelData > 0) {
                try {
                    meta.setCustomModelData(Integer.valueOf(customModelData));
                }
                catch (NoSuchMethodError e) {
                    this.plugin.getLogger().warning("CustomModelData \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u044d\u0442\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Minecraft");
                }
            }
            this.setupItemMeta(meta, itemType, placeholders);
            item.setItemMeta(meta);
        }
        return item;
    }

    private void setupItemMeta(ItemMeta meta, String itemType, Map<String, String> placeholders) {
        String name = this.plugin.getConfigManager().getGuiItemName(itemType);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            name = name.replace(entry.getKey(), entry.getValue());
        }
        meta.setDisplayName(ColorUtils.colorize(name));
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : this.plugin.getConfigManager().getGuiItemLore(itemType)) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                line = line.replace(entry.getKey(), entry.getValue());
            }
            lore.add(ColorUtils.colorize(line));
        }
        meta.setLore(lore);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null || !this.playerGuis.containsKey(player.getUniqueId())) {
            return;
        }
        Inventory playerGui = this.playerGuis.get(player.getUniqueId());
        if (!clickedInventory.equals(playerGui)) {
            return;
        }
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        if (slot == this.plugin.getConfigManager().getSlot("info")) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return;
        }
        if (slot == this.plugin.getConfigManager().getSlot("refresh")) {
            player.closeInventory();
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (player.isOnline()) {
                    this.openFriendList(player);
                }
            }, 2L);
            return;
        }
        if (slot == this.plugin.getConfigManager().getSlot("close")) {
            player.closeInventory();
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 0.5f);
            return;
        }
        int decorationStart = this.plugin.getConfigManager().getSlot("decoration-start");
        int decorationEnd = this.plugin.getConfigManager().getSlot("decoration-end");
        if (slot >= decorationStart && slot <= decorationEnd) {
            return;
        }
        this.handleFriendClick(player, item, event.isRightClick(), event.isShiftClick());
    }

    private void handleFriendClick(Player player, ItemStack item, boolean isRightClick, boolean isShiftClick) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasDisplayName()) {
            return;
        }
        String displayName = meta.getDisplayName();
        String friendName = ColorUtils.stripColor(displayName).trim();
        if (friendName.isEmpty() || friendName.equals(ColorUtils.stripColor(this.plugin.getConfigManager().getGuiItemName("info"))) || friendName.equals(ColorUtils.stripColor(this.plugin.getConfigManager().getGuiItemName("refresh"))) || friendName.equals(ColorUtils.stripColor(this.plugin.getConfigManager().getGuiItemName("close"))) || friendName.equals(" ")) {
            return;
        }
        Player friend = Bukkit.getPlayerExact((String)friendName);
        if (friend == null && !this.plugin.getFriendManager().getFriendNames(player.getUniqueId()).contains(friendName)) {
            return;
        }
        if (isShiftClick && !isRightClick && this.isMessagesAllowed()) {
            player.closeInventory();
            this.pendingMessages.put(player.getUniqueId(), friendName);
            String pendingMessage = this.plugin.getConfigManager().getGuiMessage("pending-message").replace("{player}", friendName);
            String cancelHint = this.plugin.getConfigManager().getGuiMessage("cancel-hint");
            player.sendMessage(ColorUtils.colorize(pendingMessage));
            player.sendMessage(ColorUtils.colorize(cancelHint));
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_HARP, 1.0f, 1.5f);
            return;
        }
        if (isRightClick) {
            this.plugin.getFriendManager().removeFriendship(player.getUniqueId(), Bukkit.getOfflinePlayer((String)friendName).getUniqueId());
            String friendRemovedMessage = this.plugin.getConfigManager().getGuiMessage("friend-removed").replace("{player}", friendName);
            player.sendMessage(ColorUtils.colorize(friendRemovedMessage));
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            player.closeInventory();
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (player.isOnline()) {
                    this.openFriendList(player);
                }
            }, 2L);
        } else if (this.isTeleportAllowed()) {
            Player onlineFriend = Bukkit.getPlayerExact((String)friendName);
            if (onlineFriend != null && onlineFriend.isOnline()) {
                player.closeInventory();
                player.teleport(onlineFriend.getLocation());
                String teleportedMessage = this.plugin.getConfigManager().getGuiMessage("teleported").replace("{player}", friendName);
                player.sendMessage(ColorUtils.colorize(teleportedMessage));
                player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            } else {
                String playerOfflineMessage = this.plugin.getConfigManager().getGuiMessage("player-offline").replace("{player}", friendName);
                player.sendMessage(ColorUtils.colorize(playerOfflineMessage));
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
            }
        }
    }

    public void handlePlayerChat(Player player, String message) {
        if (this.pendingMessages.containsKey(player.getUniqueId())) {
            String friendName = this.pendingMessages.remove(player.getUniqueId());
            if (message.equalsIgnoreCase("\u043e\u0442\u043c\u0435\u043d\u0430") || message.equalsIgnoreCase("cancel")) {
                String messageCancelled = this.plugin.getConfigManager().getGuiMessage("message-cancelled");
                player.sendMessage(ColorUtils.colorize(messageCancelled));
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
                return;
            }
            Player friend = Bukkit.getPlayerExact((String)friendName);
            if (friend != null && friend.isOnline()) {
                friend.sendMessage(ColorUtils.colorize("&3\u2709 \u041e\u0442 &b" + player.getName() + "&3: &f" + message));
                player.sendMessage(ColorUtils.colorize("&3\u2709 \u041a &b" + friendName + "&3: &f" + message));
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
            } else {
                String playerOfflineMessage = this.plugin.getConfigManager().getGuiMessage("player-offline").replace("{player}", friendName);
                player.sendMessage(ColorUtils.colorize(playerOfflineMessage));
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (this.playerGuis.containsKey(player.getUniqueId()) && event.getInventory().equals(this.playerGuis.get(player.getUniqueId()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        this.playerGuis.remove(player.getUniqueId());
    }

    public void cleanupPlayerData(Player player) {
        this.playerGuis.remove(player.getUniqueId());
        this.pendingMessages.remove(player.getUniqueId());
    }
}

