/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.Inffriends.manager;

import com.masterok.Inffriends.InfFriends;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final InfFriends plugin;
    private FileConfiguration config;
    private FileConfiguration messagesConfig;
    private File configFile;
    private File messagesFile;

    public ConfigManager(InfFriends plugin) {
        this.plugin = plugin;
    }

    public void loadConfigs() {
        this.plugin.saveDefaultConfig();
        this.createMessagesFile();
        this.config = this.plugin.getConfig();
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.setupDefaults();
    }

    private void createMessagesFile() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
    }

    private void setupDefaults() {
    }

    public void saveConfig() {
        this.plugin.saveConfig();
    }

    public void reloadConfigs() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }

    public boolean isPvpProtectionEnabled() {
        return this.config.getBoolean("settings.pvp-protection", true);
    }

    public boolean areJoinLeaveNotificationsEnabled() {
        return this.config.getBoolean("settings.join-leave-notifications", true);
    }

    public int getMaxFriends() {
        return this.config.getInt("settings.max-friends", 0);
    }

    public boolean isAutoAcceptRequestsEnabled() {
        return this.config.getBoolean("settings.auto-accept-requests", false);
    }

    public int getRequestExpireTime() {
        return this.config.getInt("settings.request-expire-time", 300);
    }

    public boolean isSitEnabled() {
        return this.config.getBoolean("settings.sit-enabled", true);
    }

    public boolean isGuiEnabled() {
        return this.config.getBoolean("gui.enabled", true);
    }

    public boolean isTeleportAllowed() {
        return this.config.getBoolean("gui.allow-teleport", true);
    }

    public boolean isMessagesAllowed() {
        return this.config.getBoolean("gui.allow-messages", true);
    }

    public boolean isShowLocationEnabled() {
        return this.config.getBoolean("gui.show-location", true);
    }

    public boolean isShowHealthEnabled() {
        return this.config.getBoolean("gui.show-health", true);
    }

    public boolean isShowGuiSettings() {
        return this.config.getBoolean("gui.show-gui-settings", true);
    }

    public String getGuiTitle() {
        return this.config.getString("gui.title", "&6\u0414\u0440\u0443\u0437\u044c\u044f");
    }

    public int getGuiSize() {
        return this.config.getInt("gui.size", 54);
    }

    public String getItemMaterial(String itemType) {
        return this.config.getString("gui.items." + itemType + ".material", "STONE");
    }

    public String getOraxenId(String itemType) {
        return this.config.getString("gui.items." + itemType + ".oraxen-id", "");
    }

    public int getCustomModelData(String itemType) {
        return this.config.getInt("gui.items." + itemType + ".custom-model-data", 0);
    }

    public int getSlot(String slotType) {
        return this.config.getInt("gui.slots." + slotType, 0);
    }

    public String getMessage(String key) {
        String message = this.messagesConfig.getString(key);
        if (message == null || message.isEmpty()) {
            return this.getDefaultMessage(key);
        }
        return message;
    }

    public String getCommandMessage(String key) {
        return this.getMessage("commands." + key);
    }

    public String getErrorMessage(String key) {
        return this.getMessage("errors." + key);
    }

    public String getSuccessMessage(String key) {
        return this.getMessage("success." + key);
    }

    public String getInfoMessage(String key) {
        return this.getMessage("info." + key);
    }

    public String getGuiMessage(String key) {
        return this.getMessage("gui." + key);
    }

    public String getRequestMessage(String key) {
        return this.getMessage("requests." + key);
    }

    public String getGuiItemName(String itemType) {
        return this.messagesConfig.getString("gui.items." + itemType + ".name", this.getDefaultItemName(itemType));
    }

    public List<String> getGuiItemLore(String itemType) {
        List lore = this.messagesConfig.getStringList("gui.items." + itemType + ".lore");
        if (lore.isEmpty()) {
            return this.getDefaultItemLore(itemType);
        }
        return lore;
    }

    private String getDefaultMessage(String key) {
        switch (key) {
            case "commands.help-header": {
                return "&6\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac";
            }
            case "commands.help-title": {
                return "&e               \u2726 &6InfFriends &e\u2726";
            }
            case "commands.help-add": {
                return "&a/f add <\u0438\u0433\u0440\u043e\u043a> &7- &a\u2713 &a\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f";
            }
            case "commands.help-remove": {
                return "&a/f remove <\u0438\u0433\u0440\u043e\u043a> &7- &c\u2613 &c\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0437 \u0434\u0440\u0443\u0437\u0435\u0439";
            }
            case "commands.help-list": {
                return "&a/f list &7- &b\u2261 &b\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0434\u0440\u0443\u0437\u0435\u0439";
            }
            case "commands.help-accept": {
                return "&a/f accept &7- &a\u2713 &a\u041f\u0440\u0438\u043d\u044f\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f";
            }
            case "commands.help-deny": {
                return "&a/f deny &7- &c\u2613 &c\u041e\u0442\u043a\u043b\u043e\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f";
            }
            case "commands.help-menu": {
                return "&a/f menu &7- &e\u2630 &e\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u043c\u0435\u043d\u044e \u0434\u0440\u0443\u0437\u0435\u0439";
            }
            case "commands.help-msg": {
                return "&a/f msg <\u0438\u0433\u0440\u043e\u043a> <\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435> &7- &b\u2709 &b\u041d\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u043b\u0438\u0447\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435";
            }
            case "commands.help-sit": {
                return "&a/f sit <\u0438\u0433\u0440\u043e\u043a> &7- &e\u2658 &e\u0421\u0435\u0441\u0442\u044c \u043d\u0430 \u0433\u043e\u043b\u043e\u0432\u0443 \u0434\u0440\u0443\u0433\u0430";
            }
            case "commands.help-help": {
                return "&a/f help &7- &e? &e\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u044d\u0442\u0443 \u043f\u043e\u043c\u043e\u0449\u044c";
            }
            case "commands.help-reload": {
                return "&a/f reload &7- &e\u2699 &e\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e";
            }
            case "commands.help-aliases": {
                return "&7\ud83d\udca1 &7\u0410\u043b\u0438\u0430\u0441\u044b: &f/friends&7, &f/\u0434\u0440";
            }
            case "commands.help-messages": {
                return "&7\ud83d\udcac &7\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f: &f/f msg&7, &f/f m&7, &f/f tell";
            }
            case "commands.help-sit-aliases": {
                return "&7\ud83d\udc31 &7\u0421\u0438\u0434\u0435\u0442\u044c: &f/f sit&7, &f/f ride";
            }
            case "errors.only-players": {
                return "&c\u2613 \u042d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443 \u043c\u043e\u0433\u0443\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u0438!";
            }
            case "errors.player-not-found": {
                return "&c\u2613 \u0418\u0433\u0440\u043e\u043a &4{player} &c\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!";
            }
            case "errors.player-offline": {
                return "&c\u2613 \u0418\u0433\u0440\u043e\u043a &4{player} &c\u043d\u0435 \u0432 \u0441\u0435\u0442\u0438!";
            }
            case "errors.self-add": {
                return "&c\u2613 \u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u0435\u0431\u044f \u0432 \u0434\u0440\u0443\u0437\u044c\u044f!";
            }
            case "errors.already-friends": {
                return "&c\u2613 \u0418\u0433\u0440\u043e\u043a &4{player} &c\u0443\u0436\u0435 \u0432 \u0432\u0430\u0448\u0435\u043c \u0441\u043f\u0438\u0441\u043a\u0435 \u0434\u0440\u0443\u0437\u0435\u0439!";
            }
            case "errors.not-friends": {
                return "&c\u2613 \u0418\u0433\u0440\u043e\u043a &4{player} &c\u043d\u0435 \u0432 \u0432\u0430\u0448\u0435\u043c \u0441\u043f\u0438\u0441\u043a\u0435 \u0434\u0440\u0443\u0437\u0435\u0439!";
            }
            case "errors.no-pending-requests": {
                return "&c\u2613 \u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043e\u0436\u0438\u0434\u0430\u044e\u0449\u0438\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f!";
            }
            case "errors.max-friends": {
                return "&c\u2613 \u0412\u044b \u0434\u043e\u0441\u0442\u0438\u0433\u043b\u0438 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u0434\u0440\u0443\u0437\u0435\u0439! &4({max})";
            }
            case "errors.target-max-friends": {
                return "&c\u2613 \u0423 \u0438\u0433\u0440\u043e\u043a\u0430 \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043b\u0438\u043c\u0438\u0442 \u0434\u0440\u0443\u0437\u0435\u0439! &4({max})";
            }
            case "errors.request-expired": {
                return "&c\u2613 \u0417\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f \u0438\u0441\u0442\u0435\u043a!";
            }
            case "errors.no-permission": {
                return "&c\u2613 \u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!";
            }
            case "errors.pvp-blocked": {
                return "&c\u2613 \u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0430\u0442\u0430\u043a\u043e\u0432\u0430\u0442\u044c \u0441\u0432\u043e\u0435\u0433\u043e \u0434\u0440\u0443\u0433\u0430 &4{player}&c!";
            }
            case "errors.sit-disabled": {
                return "&c\u2613 \u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0441\u0438\u0434\u0435\u043d\u0438\u044f \u043d\u0430 \u0433\u043e\u043b\u043e\u0432\u0430\u0445 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0433\u0438\u043d\u0430!";
            }
            case "errors.sit-too-far": {
                return "&c\u2613 \u0418\u0433\u0440\u043e\u043a \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u0430\u043b\u0435\u043a\u043e! \u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0440\u0430\u0441\u0441\u0442\u043e\u044f\u043d\u0438\u0435: 10 \u0431\u043b\u043e\u043a\u043e\u0432";
            }
            case "errors.sit-self": {
                return "&c\u2613 \u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0441\u0438\u0434\u0435\u0442\u044c \u043d\u0430 \u0441\u0432\u043e\u0435\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0433\u043e\u043b\u043e\u0432\u0435!";
            }
            case "errors.sit-not-friends": {
                return "&c\u2613 \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0441\u0438\u0434\u0435\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0433\u043e\u043b\u043e\u0432\u0430\u0445 \u0441\u0432\u043e\u0438\u0445 \u0434\u0440\u0443\u0437\u0435\u0439!";
            }
            case "success.request-sent": {
                return "&a\u2713 \u0417\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u0438\u0433\u0440\u043e\u043a\u0443 &2{player}&a!";
            }
            case "success.request-accepted": {
                return "&a\u2713 \u0412\u044b \u043f\u0440\u0438\u043d\u044f\u043b\u0438 \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f \u043e\u0442 &2{player}&a!";
            }
            case "success.request-accepted-sender": {
                return "&a\u2713 \u0418\u0433\u0440\u043e\u043a &2{player} &a\u043f\u0440\u0438\u043d\u044f\u043b \u0432\u0430\u0448 \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f!";
            }
            case "success.request-denied": {
                return "&c\u2613 \u0412\u044b \u043e\u0442\u043a\u043b\u043e\u043d\u0438\u043b\u0438 \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f \u043e\u0442 &4{player}&c.";
            }
            case "success.request-denied-sender": {
                return "&c\u2613 \u0418\u0433\u0440\u043e\u043a &4{player} &c\u043e\u0442\u043a\u043b\u043e\u043d\u0438\u043b \u0432\u0430\u0448 \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f.";
            }
            case "success.friend-removed": {
                return "&a\u2713 \u0418\u0433\u0440\u043e\u043a &2{player} &a\u0443\u0434\u0430\u043b\u0435\u043d \u0438\u0437 \u0434\u0440\u0443\u0437\u0435\u0439!";
            }
            case "success.teleported": {
                return "&a\u2708 \u0422\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a &2{player}";
            }
            case "success.reloaded": {
                return "&a\u2713 \u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430!";
            }
            case "success.new-friend": {
                return "&b\u25cf \u0422\u0435\u043f\u0435\u0440\u044c \u0432\u044b \u0434\u0440\u0443\u0437\u044c\u044f \u0441 &3{player}&b!";
            }
            case "info.friend-list-empty": {
                return "&e\u2261 \u0423 \u0432\u0430\u0441 \u043f\u043e\u043a\u0430 \u043d\u0435\u0442 \u0434\u0440\u0443\u0437\u0435\u0439!";
            }
            case "info.friend-list-hint": {
                return "&7\u25cf \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 &f/f add <\u0438\u0433\u0440\u043e\u043a> &7\u0447\u0442\u043e\u0431\u044b \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0434\u0440\u0443\u0433\u0430";
            }
            case "info.friend-list-header": {
                return "&e               \u2726 &6\u0412\u0430\u0448\u0438 \u0434\u0440\u0443\u0437\u044c\u044f &e\u2726";
            }
            case "info.friend-list-stats": {
                return "&a\u25cf \u0412\u0441\u0435\u0433\u043e: &2{total} &a| &2\u25cf \u041e\u043d\u043b\u0430\u0439\u043d: &2{online}";
            }
            case "info.friend-online": {
                return "  &a\u2713 &a{player} &2\u25cf \u043e\u043d\u043b\u0430\u0439\u043d";
            }
            case "info.friend-offline": {
                return "  &7\u2613 &7{player} &8\u25cf \u043e\u0444\u0444\u043b\u0430\u0439\u043d";
            }
            case "info.join-notification": {
                return "&b\u25cf \u0412\u0430\u0448 \u0434\u0440\u0443\u0433 &3{player} &b\u0437\u0430\u0448\u0435\u043b \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440!";
            }
            case "info.leave-notification": {
                return "&c\u25cf \u0412\u0430\u0448 \u0434\u0440\u0443\u0433 &4{player} &c\u0432\u044b\u0448\u0435\u043b \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430!";
            }
            case "info.message-sent": {
                return "&3\u2709 \u041a &b{player}&3: &f{message}";
            }
            case "info.message-received": {
                return "&3\u2709 \u041e\u0442 &b{player}&3: &f{message}";
            }
            case "info.sit-success": {
                return "&a\u2658 \u0412\u044b \u0441\u0435\u043b\u0438 \u043d\u0430 \u0433\u043e\u043b\u043e\u0432\u0443 &2{player}&a!";
            }
            case "info.sit-target": {
                return "&a\u2658 \u0418\u0433\u0440\u043e\u043a &2{player} &a\u0441\u0435\u043b \u043d\u0430 \u0432\u0430\u0448\u0443 \u0433\u043e\u043b\u043e\u0432\u0443!";
            }
            case "gui.pending-message": {
                return "&b\u2709 \u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0434\u043b\u044f &3{player}&b:";
            }
            case "gui.cancel-hint": {
                return "&7\u25cf \u041d\u0430\u043f\u0438\u0448\u0438\u0442\u0435 \u0432 \u0447\u0430\u0442 \u0438\u043b\u0438 '&c\u043e\u0442\u043c\u0435\u043d\u0430&7' \u0434\u043b\u044f \u043e\u0442\u043c\u0435\u043d\u044b";
            }
            case "gui.message-cancelled": {
                return "&c\u2613 \u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430";
            }
            case "gui.teleported": {
                return "&a\u2708 \u0422\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043a &2{player}";
            }
            case "gui.player-offline": {
                return "&c\u2613 \u0418\u0433\u0440\u043e\u043a &4{player} &c\u043d\u0435 \u0432 \u0441\u0435\u0442\u0438";
            }
            case "gui.friend-removed": {
                return "&a\u2713 \u0418\u0433\u0440\u043e\u043a &2{player} &a\u0443\u0434\u0430\u043b\u0435\u043d \u0438\u0437 \u0434\u0440\u0443\u0437\u0435\u0439";
            }
            case "gui.gui-disabled": {
                return "&c\u2613 GUI \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0433\u0438\u043d\u0430";
            }
            case "gui.gui-error": {
                return "&c\u2613 \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0438 GUI";
            }
            case "requests.title": {
                return "&e              \u2726 &6\u041d\u043e\u0432\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f &e\u2726";
            }
            case "requests.player": {
                return "&b\u25cf \u0418\u0433\u0440\u043e\u043a: &3{player}";
            }
            case "requests.message": {
                return "&e\u25cf \u0425\u043e\u0447\u0435\u0442 \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u0430\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f!";
            }
            case "requests.accept-button": {
                return "&a[\u2713 \u041f\u0420\u0418\u041d\u042f\u0422\u042c]";
            }
            case "requests.accept-hover": {
                return "&a\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0447\u0442\u043e\u0431\u044b \u043f\u0440\u0438\u043d\u044f\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f";
            }
            case "requests.deny-button": {
                return "&c[\u2613 \u041e\u0422\u041a\u041b\u041e\u041d\u0418\u0422\u042c]";
            }
            case "requests.deny-hover": {
                return "&c\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043a\u043b\u043e\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441";
            }
            case "requests.expire": {
                return "&e\u231b \u0417\u0430\u043f\u0440\u043e\u0441 \u0438\u0441\u0442\u0435\u0447\u0435\u0442 \u0447\u0435\u0440\u0435\u0437 &6{time}&e \u0441\u0435\u043a\u0443\u043d\u0434";
            }
        }
        return "&c\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + key;
    }

    private String getDefaultItemName(String itemType) {
        switch (itemType) {
            case "online-friend": {
                return "&a{player}";
            }
            case "offline-friend": {
                return "&7{player}";
            }
            case "info": {
                return "&b\u2261 \u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0434\u0440\u0443\u0437\u044c\u044f\u0445";
            }
            case "refresh": {
                return "&a\u21bb \u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a";
            }
            case "close": {
                return "&c\u2613 \u0417\u0430\u043a\u0440\u044b\u0442\u044c";
            }
            case "decoration": {
                return " ";
            }
        }
        return "&fItem";
    }

    private List<String> getDefaultItemLore(String itemType) {
        ArrayList<String> lore = new ArrayList<String>();
        switch (itemType) {
            case "online-friend": {
                lore.add("&2\u25cf \u043e\u043d\u043b\u0430\u0439\u043d");
                lore.add("");
                lore.add("&e\u2708 \u041b\u041a\u041c - \u0422\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f");
                lore.add("&c\u2613 \u041f\u041a\u041c - \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0437 \u0434\u0440\u0443\u0437\u0435\u0439");
                lore.add("&b\u2709 Shift+\u041b\u041a\u041c - \u041d\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
                lore.add("");
                lore.add("&7\u25cf \u041c\u0435\u0441\u0442\u043e\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435: &f{location}");
                lore.add("&7\u2764 \u0417\u0434\u043e\u0440\u043e\u0432\u044c\u0435: &c{health} HP");
                break;
            }
            case "offline-friend": {
                lore.add("&8\u25cf \u043e\u0444\u0444\u043b\u0430\u0439\u043d");
                lore.add("");
                lore.add("&c\u2613 \u041f\u041a\u041c - \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0437 \u0434\u0440\u0443\u0437\u0435\u0439");
                lore.add("");
                lore.add("&7\u231b \u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u0432\u0445\u043e\u0434: &f{last-seen}");
                break;
            }
            case "info": {
                lore.add("&a\u25cf \u0412\u0441\u0435\u0433\u043e \u0434\u0440\u0443\u0437\u0435\u0439: &2{total}");
                lore.add("&a\u25cf \u041e\u043d\u043b\u0430\u0439\u043d: &2{online}");
                lore.add("&c\u25cf \u041e\u0444\u0444\u043b\u0430\u0439\u043d: &4{offline}");
                lore.add("");
                lore.add("&e\u2699 \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 GUI:");
                lore.add("&7{teleport-status} \u0422\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0430\u0446\u0438\u044f: {teleport-value}");
                lore.add("&7{messages-status} \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f: {messages-value}");
                lore.add("&7{location-status} \u041b\u043e\u043a\u0430\u0446\u0438\u044f: {location-value}");
                lore.add("&7{health-status} \u0417\u0434\u043e\u0440\u043e\u0432\u044c\u0435: {health-value}");
                break;
            }
            case "refresh": {
                lore.add("&e\u25cf \u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0447\u0442\u043e\u0431\u044b \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0434\u0440\u0443\u0437\u0435\u0439");
                break;
            }
            case "close": {
                lore.add("&e\u25cf \u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0447\u0442\u043e\u0431\u044b \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u043c\u0435\u043d\u044e");
                break;
            }
        }
        return lore;
    }

    public String getMessagePrefix() {
        return this.messagesConfig.getString("prefix", "&6InfFriends &8|");
    }

    public String getDateFormat() {
        return this.messagesConfig.getString("date-format", "dd.MM.yyyy HH:mm");
    }
}

