/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.Inffriends.manager;

import com.masterok.Inffriends.InfFriends;
import com.masterok.Inffriends.util.ColorUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FriendRequestManager {
    private final InfFriends plugin;
    private final Map<UUID, RequestData> pendingRequests;

    public FriendRequestManager(InfFriends plugin) {
        this.plugin = plugin;
        this.pendingRequests = new HashMap<UUID, RequestData>();
        this.startExpirationCheck();
    }

    public void sendRequest(Player sender, Player target) {
        if (!this.plugin.getFriendManager().canAddFriend(sender.getUniqueId())) {
            int maxFriends = this.plugin.getConfigManager().getMaxFriends();
            this.sendMessage(sender, "&c\u2717 &c\u0412\u044b \u0434\u043e\u0441\u0442\u0438\u0433\u043b\u0438 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u0434\u0440\u0443\u0437\u0435\u0439! &4(" + maxFriends + ")");
            return;
        }
        if (!this.plugin.getFriendManager().canAddFriend(target.getUniqueId())) {
            int maxFriends = this.plugin.getConfigManager().getMaxFriends();
            this.sendMessage(sender, "&c\u2717 &c\u0423 \u0438\u0433\u0440\u043e\u043a\u0430 \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043b\u0438\u043c\u0438\u0442 \u0434\u0440\u0443\u0437\u0435\u0439! &4(" + maxFriends + ")");
            return;
        }
        this.pendingRequests.put(target.getUniqueId(), new RequestData(sender.getUniqueId()));
        this.sendMessage(sender, "&a\u2713 &a\u0417\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u0438\u0433\u0440\u043e\u043a\u0443 &2" + target.getName() + "&a!");
        this.sendInteractiveRequestMessage(target, sender.getName());
    }

    private void sendInteractiveRequestMessage(Player target, String senderName) {
        target.sendMessage(ColorUtils.colorize("&6\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac"));
        target.sendMessage(ColorUtils.colorize("&e              &l\u041d\u043e\u0432\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f"));
        target.sendMessage(ColorUtils.colorize("&6\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac"));
        target.sendMessage(ColorUtils.colorize("&b\u0418\u0433\u0440\u043e\u043a: &3" + senderName));
        target.sendMessage(ColorUtils.colorize("&e\u0425\u043e\u0447\u0435\u0442 \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u0430\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f!"));
        target.sendMessage("");
        TextComponent acceptButton = new TextComponent(ColorUtils.colorize("&a[\u2713 \u041f\u0420\u0418\u041d\u042f\u0422\u042c]"));
        acceptButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/friend accept"));
        acceptButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ColorUtils.colorize("&a\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0447\u0442\u043e\u0431\u044b \u043f\u0440\u0438\u043d\u044f\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f")).create()));
        TextComponent denyButton = new TextComponent(ColorUtils.colorize(" &c[\u2717 \u041e\u0422\u041a\u041b\u041e\u041d\u0418\u0422\u042c]"));
        denyButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/friend deny"));
        denyButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ColorUtils.colorize("&c\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043a\u043b\u043e\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441")).create()));
        target.spigot().sendMessage(new BaseComponent[]{acceptButton, denyButton});
        target.sendMessage("");
        target.sendMessage(ColorUtils.colorize("&e\u0417\u0430\u043f\u0440\u043e\u0441 \u0438\u0441\u0442\u0435\u0447\u0435\u0442 \u0447\u0435\u0440\u0435\u0437 &6" + this.plugin.getConfigManager().getRequestExpireTime() + "&e \u0441\u0435\u043a\u0443\u043d\u0434"));
        target.sendMessage(ColorUtils.colorize("&6\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac"));
        target.playSound(target.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.5f);
    }

    public boolean hasPendingRequest(Player player) {
        RequestData data = this.pendingRequests.get(player.getUniqueId());
        if (data == null) {
            return false;
        }
        int expireTime = this.plugin.getConfigManager().getRequestExpireTime() * 1000;
        if (expireTime > 0 && System.currentTimeMillis() - data.timestamp > (long)expireTime) {
            this.pendingRequests.remove(player.getUniqueId());
            return false;
        }
        return true;
    }

    public Player getRequester(Player player) {
        RequestData data = this.pendingRequests.get(player.getUniqueId());
        return data != null ? Bukkit.getPlayer((UUID)data.requesterUUID) : null;
    }

    public void acceptRequest(Player player) {
        RequestData data = this.pendingRequests.remove(player.getUniqueId());
        if (data == null) {
            this.sendMessage(player, "&c\u2717 &c\u0417\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f \u0438\u0441\u0442\u0435\u043a \u0438\u043b\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
            return;
        }
        Player requester = Bukkit.getPlayer((UUID)data.requesterUUID);
        if (requester != null && requester.isOnline()) {
            this.plugin.getFriendManager().addFriendship(data.requesterUUID, player.getUniqueId());
            this.sendMessage(requester, "&a\u2713 &a\u0418\u0433\u0440\u043e\u043a &2" + player.getName() + " &a\u043f\u0440\u0438\u043d\u044f\u043b \u0432\u0430\u0448 \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f!");
            this.sendMessage(player, "&a\u2713 &a\u0412\u044b \u043f\u0440\u0438\u043d\u044f\u043b\u0438 \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f \u043e\u0442 &2" + requester.getName() + "&a!");
            requester.playSound(requester.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
            if (this.plugin.getConfigManager().areJoinLeaveNotificationsEnabled()) {
                this.sendMessage(requester, "&b\u0422\u0435\u043f\u0435\u0440\u044c \u0432\u044b \u0434\u0440\u0443\u0437\u044c\u044f \u0441 &3" + player.getName() + "&b!");
                this.sendMessage(player, "&b\u0422\u0435\u043f\u0435\u0440\u044c \u0432\u044b \u0434\u0440\u0443\u0437\u044c\u044f \u0441 &3" + requester.getName() + "&b!");
            }
        } else {
            this.sendMessage(player, "&c\u2717 &c\u0418\u0433\u0440\u043e\u043a, \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0432\u0448\u0438\u0439 \u0437\u0430\u043f\u0440\u043e\u0441, \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0432 \u0441\u0435\u0442\u0438!");
        }
    }

    public void denyRequest(Player player) {
        RequestData data = this.pendingRequests.remove(player.getUniqueId());
        if (data == null) {
            this.sendMessage(player, "&c\u2717 &c\u0417\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f \u0438\u0441\u0442\u0435\u043a \u0438\u043b\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
            return;
        }
        Player requester = Bukkit.getPlayer((UUID)data.requesterUUID);
        if (requester != null && requester.isOnline()) {
            this.sendMessage(requester, "&c\u2717 &c\u0418\u0433\u0440\u043e\u043a &4" + player.getName() + " &c\u043e\u0442\u043a\u043b\u043e\u043d\u0438\u043b \u0432\u0430\u0448 \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f.");
            this.sendMessage(player, "&c\u2717 &c\u0412\u044b \u043e\u0442\u043a\u043b\u043e\u043d\u0438\u043b\u0438 \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f \u043e\u0442 &4" + requester.getName() + "&c.");
            requester.playSound(requester.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
        }
    }

    public void removeRequest(Player player) {
        this.pendingRequests.remove(player.getUniqueId());
    }

    private void startExpirationCheck() {
        new BukkitRunnable(){

            public void run() {
                FriendRequestManager.this.cleanupExpiredRequests();
            }
        }.runTaskTimer((Plugin)this.plugin, 6000L, 6000L);
    }

    private void cleanupExpiredRequests() {
        int expireTime = this.plugin.getConfigManager().getRequestExpireTime() * 1000;
        if (expireTime <= 0) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        this.pendingRequests.entrySet().removeIf(entry -> {
            if (currentTime - ((RequestData)entry.getValue()).timestamp > (long)expireTime) {
                Player target = Bukkit.getPlayer((UUID)((UUID)entry.getKey()));
                if (target != null && target.isOnline()) {
                    this.sendMessage(target, "&c\u2717 &c\u041e\u0434\u0438\u043d \u0438\u0437 \u0432\u0430\u0448\u0438\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432 \u0432 \u0434\u0440\u0443\u0437\u044c\u044f \u0438\u0441\u0442\u0435\u043a!");
                }
                return true;
            }
            return false;
        });
    }

    private void sendMessage(Player player, String message) {
        player.sendMessage(ColorUtils.colorize(message));
    }

    public boolean shouldAutoAccept() {
        return this.plugin.getConfigManager().isAutoAcceptRequestsEnabled();
    }

    public int getPendingRequestCount(Player player) {
        return this.pendingRequests.containsKey(player.getUniqueId()) ? 1 : 0;
    }

    public void clearAllRequests() {
        this.pendingRequests.clear();
    }

    private static class RequestData {
        UUID requesterUUID;
        long timestamp;

        RequestData(UUID requesterUUID) {
            this.requesterUUID = requesterUUID;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

