/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.Inffriends.util;

import com.masterok.Inffriends.InfFriends;
import com.masterok.Inffriends.util.ColorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class MessageUtils {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{([^}]+)\\}");

    public static void sendMessage(CommandSender sender, String key, String ... replacements) {
        String message = MessageUtils.getMessage(key, replacements);
        if (message != null && !message.isEmpty()) {
            sender.sendMessage(ColorUtils.colorize(message));
        }
    }

    public static String getMessage(String key, String ... replacements) {
        String prefix;
        InfFriends plugin = InfFriends.getInstance();
        if (plugin == null || plugin.getConfigManager() == null) {
            return "\u00a7cPlugin not initialized";
        }
        FileConfiguration messages = plugin.getConfigManager().getMessagesConfig();
        if (messages == null) {
            return "\u00a7cMessages config not loaded";
        }
        String message = messages.getString(key);
        if (message == null) {
            if (key.startsWith("errors.")) {
                message = "\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430: " + key.replace("errors.", "");
            } else if (key.startsWith("success.")) {
                message = "\u00a7a" + key.replace("success.", "");
            } else if (key.startsWith("info.")) {
                message = "\u00a7e" + key.replace("info.", "");
            } else {
                return "\u00a7cMessage not found: " + key;
            }
        }
        message = MessageUtils.replacePlaceholders(message, replacements);
        if (!(key.startsWith("gui.") || key.startsWith("commands.help") || (prefix = messages.getString("prefix")) == null || prefix.isEmpty())) {
            message = message.replace("{prefix}", prefix);
        }
        return message;
    }

    public static List<String> getMessageList(String key, String ... replacements) {
        InfFriends plugin = InfFriends.getInstance();
        FileConfiguration messages = plugin.getConfigManager().getMessagesConfig();
        ArrayList<String> messageList = messages.getStringList(key);
        if (messageList.isEmpty()) {
            String singleMessage = messages.getString(key);
            if (singleMessage != null) {
                messageList = new ArrayList<String>();
                messageList.add(singleMessage);
            } else {
                ArrayList<String> defaultList = new ArrayList<String>();
                defaultList.add("\u00a7cMessage list not found: " + key);
                return defaultList;
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String line : messageList) {
            String prefix;
            String processedLine = MessageUtils.replacePlaceholders(line, replacements);
            if (!(key.startsWith("gui.") || key.startsWith("commands.help") || (prefix = messages.getString("prefix")) == null || prefix.isEmpty())) {
                processedLine = processedLine.replace("{prefix}", prefix);
            }
            result.add(processedLine);
        }
        return result;
    }

    private static String replacePlaceholders(String text, String[] replacements) {
        if (text == null) {
            return "";
        }
        String result = text;
        if (replacements.length % 2 == 0) {
            for (int i = 0; i < replacements.length; i += 2) {
                if (i + 1 >= replacements.length) continue;
                result = result.replace("{" + replacements[i] + "}", replacements[i + 1]);
            }
        }
        return result;
    }
}

