/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.Inffriends.util;

import java.util.logging.Logger;
import org.bukkit.Bukkit;

public class VersionManager {
    private static VersionManager instance;
    private final String serverVersion;
    private final int majorVersion;
    private final int minorVersion;
    private final Logger logger;

    public VersionManager(Logger logger) {
        this.logger = logger;
        this.serverVersion = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        String[] versionParts = Bukkit.getBukkitVersion().split("\\-")[0].split("\\.");
        this.majorVersion = Integer.parseInt(versionParts[0]);
        this.minorVersion = Integer.parseInt(versionParts[1]);
        logger.info("Detected Minecraft version: " + this.majorVersion + "." + this.minorVersion);
    }

    public static VersionManager getInstance(Logger logger) {
        if (instance == null) {
            instance = new VersionManager(logger);
        }
        return instance;
    }

    public boolean isVersionOrHigher(int major, int minor) {
        return this.majorVersion > major || this.majorVersion == major && this.minorVersion >= minor;
    }

    public String getNMSVersion() {
        return this.serverVersion;
    }
}

