/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.inffriend.friend;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class FriendRequestService {
    private final Map<UUID, Map<UUID, Request>> incoming = new HashMap<UUID, Map<UUID, Request>>();

    public void create(UUID from, UUID to) {
        this.incoming.computeIfAbsent(to, k -> new HashMap()).put(from, new Request(from, to, System.currentTimeMillis()));
    }

    public Request get(UUID from, UUID to) {
        Map<UUID, Request> map = this.incoming.get(to);
        if (map == null) {
            return null;
        }
        return map.get(from);
    }

    public void remove(UUID from, UUID to) {
        Map<UUID, Request> map = this.incoming.get(to);
        if (map == null) {
            return;
        }
        map.remove(from);
        if (map.isEmpty()) {
            this.incoming.remove(to);
        }
    }

    public void cleanupExpired(long expireMillis) {
        long now = System.currentTimeMillis();
        for (UUID to : new ArrayList<UUID>(this.incoming.keySet())) {
            Map<UUID, Request> map = this.incoming.get(to);
            if (map == null) continue;
            for (UUID from : new ArrayList<UUID>(map.keySet())) {
                Request r = map.get(from);
                if (r == null || now - r.createdMillis <= expireMillis) continue;
                map.remove(from);
            }
            if (!map.isEmpty()) continue;
            this.incoming.remove(to);
        }
    }

    public static class Request {
        public final UUID from;
        public final UUID to;
        public final long createdMillis;

        public Request(UUID from, UUID to, long createdMillis) {
            this.from = from;
            this.to = to;
            this.createdMillis = createdMillis;
        }
    }
}

