/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.inffriend.sit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class SitRequestService {
    private final Map<UUID, Map<UUID, Request>> incoming = new HashMap<UUID, Map<UUID, Request>>();

    public void create(UUID rider, UUID target) {
        Map<UUID, Request> map = this.incoming.get(target);
        if (map == null) {
            map = new HashMap<UUID, Request>();
            this.incoming.put(target, map);
        }
        map.put(rider, new Request(rider, target, System.currentTimeMillis()));
    }

    public Request get(UUID rider, UUID target) {
        Map<UUID, Request> map = this.incoming.get(target);
        if (map == null) {
            return null;
        }
        return map.get(rider);
    }

    public void remove(UUID rider, UUID target) {
        Map<UUID, Request> map = this.incoming.get(target);
        if (map == null) {
            return;
        }
        map.remove(rider);
        if (map.isEmpty()) {
            this.incoming.remove(target);
        }
    }

    public void cleanup(long expireMillis) {
        long now = System.currentTimeMillis();
        for (UUID target : new ArrayList<UUID>(this.incoming.keySet())) {
            Map<UUID, Request> map = this.incoming.get(target);
            if (map == null) continue;
            for (UUID rider : new ArrayList<UUID>(map.keySet())) {
                Request r = map.get(rider);
                if (r == null || now - r.createdMillis <= expireMillis) continue;
                map.remove(rider);
            }
            if (!map.isEmpty()) continue;
            this.incoming.remove(target);
        }
    }

    public static class Request {
        public final UUID rider;
        public final UUID target;
        public final long createdMillis;

        public Request(UUID rider, UUID target, long createdMillis) {
            this.rider = rider;
            this.target = target;
            this.createdMillis = createdMillis;
        }
    }
}

