/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.InfPassport;

import com.masterok.InfPassport.commands.PassportCommand;
import com.masterok.InfPassport.db.PassportDatabase;
import com.masterok.InfPassport.service.AskManager;
import com.masterok.InfPassport.service.PassportService;
import com.masterok.InfPassport.service.UpdateChecker;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;

public final class InfPassport
extends JavaPlugin {
    private PassportDatabase database;
    private UpdateChecker updateChecker;

    public void onEnable() {
        if (this.getResource("config.yml") != null) {
            this.saveDefaultConfig();
        } else {
            this.getLogger().warning("config.yml not found inside jar. Plugin will run with empty/default config values.");
        }
        this.database = new PassportDatabase(this);
        this.database.init();
        PassportService passportService = new PassportService(this, this.database);
        AskManager askManager = new AskManager(this);
        this.updateChecker = new UpdateChecker(this, "https://masterok.space/Plugins/InfPassport/version.txt");
        this.updateChecker.checkAsync(null);
        PluginCommand cmd = this.getCommand("passport");
        if (cmd != null) {
            PassportCommand passportCommand = new PassportCommand(this, passportService, askManager, this.updateChecker);
            cmd.setExecutor((CommandExecutor)passportCommand);
            cmd.setTabCompleter((TabCompleter)passportCommand);
        } else {
            this.getLogger().severe("Command 'passport' not found. Check plugin.yml!");
        }
    }

    public void onDisable() {
        if (this.database != null) {
            this.database.close();
        }
    }

    public void reloadPlugin() {
        this.reloadConfig();
    }
}

