/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.InfPassport.commands;

import com.masterok.InfPassport.InfPassport;
import com.masterok.InfPassport.model.Passport;
import com.masterok.InfPassport.service.AskManager;
import com.masterok.InfPassport.service.PassportService;
import com.masterok.InfPassport.service.UpdateChecker;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class PassportCommand
implements CommandExecutor,
TabCompleter {
    private final InfPassport plugin;
    private final PassportService service;
    private final AskManager askManager;
    private final UpdateChecker updateChecker;

    public PassportCommand(InfPassport plugin, PassportService service, AskManager askManager, UpdateChecker updateChecker) {
        this.plugin = plugin;
        this.service = service;
        this.askManager = askManager;
        this.updateChecker = updateChecker;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        String sub = args[0].toLowerCase(Locale.ROOT);
        if (sub.equals("help")) {
            this.sendHelp(sender);
            return true;
        }
        switch (sub) {
            case "reload": {
                if (!sender.hasPermission("infpassport.reload")) {
                    sender.sendMessage(this.msg("messages.no-permission"));
                    return true;
                }
                this.plugin.reloadPlugin();
                sender.sendMessage(this.msg("messages.reloaded"));
                if (this.updateChecker != null) {
                    this.updateChecker.checkAsync(sender);
                }
                return true;
            }
            case "new": {
                if (!sender.hasPermission("infpassport.new")) {
                    sender.sendMessage(this.msg("messages.no-permission"));
                    return true;
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.msg("messages.player-only"));
                    return true;
                }
                if (args.length < 5) {
                    sender.sendMessage(this.msg("messages.new-usage"));
                    return true;
                }
                Player issuer = (Player)sender;
                String targetName = args[1];
                OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
                String realName = args[2];
                String gender = args[3];
                String birthInput = args[4];
                PassportService.BirthdateCheck check = this.service.validateBirthdate(birthInput);
                if (!check.ok) {
                    if ("messages.birthdate-too-young".equals(check.errorKey)) {
                        sender.sendMessage(this.msg(check.errorKey).replace("%min%", String.valueOf(check.minAge)));
                    } else {
                        String fmt = this.plugin.getConfig().getString("rules.birthdate-format", "DD.MM.YYYY");
                        sender.sendMessage(this.msg(check.errorKey).replace("%format%", fmt));
                    }
                    return true;
                }
                this.service.createPassport(issuer, target, realName, gender, check.birthIso);
                sender.sendMessage(this.msg("messages.passport-created").replace("%player%", targetName));
                return true;
            }
            case "delete": {
                if (!sender.hasPermission("infpassport.delete")) {
                    sender.sendMessage(this.msg("messages.no-permission"));
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(this.msg("messages.delete-usage"));
                    return true;
                }
                OfflinePlayer delTarget = Bukkit.getOfflinePlayer((String)args[1]);
                boolean ok = this.service.deletePassport(delTarget.getUniqueId());
                sender.sendMessage(ok ? this.msg("messages.passport-deleted").replace("%player%", args[1]) : this.msg("messages.passport-not-found"));
                return true;
            }
            case "edit": {
                if (!sender.hasPermission("infpassport.edit")) {
                    sender.sendMessage(this.msg("messages.no-permission"));
                    return true;
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.msg("messages.player-only"));
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage(this.msg("messages.edit-usage"));
                    return true;
                }
                Player player = (Player)sender;
                String field = args[1];
                StringBuilder sb = new StringBuilder();
                for (int i = 2; i < args.length; ++i) {
                    if (i > 2) {
                        sb.append(' ');
                    }
                    sb.append(args[i]);
                }
                String value = sb.toString();
                this.service.editField(player.getUniqueId(), field, value);
                sender.sendMessage(this.color("&a\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u043e: &e" + field + " &a= &e" + value));
                return true;
            }
            case "show": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.msg("messages.player-only"));
                    return true;
                }
                Player viewer = (Player)sender;
                if (args.length == 1) {
                    Optional<Passport> self = this.service.getPassport(viewer.getUniqueId());
                    if (!self.isPresent()) {
                        viewer.sendMessage(this.msg("messages.passport-not-found"));
                        return true;
                    }
                    this.service.openPassport(viewer, self.get());
                    return true;
                }
                if (!sender.hasPermission("infpassport.show")) {
                    sender.sendMessage(this.msg("messages.no-permission"));
                    return true;
                }
                OfflinePlayer showTarget = Bukkit.getOfflinePlayer((String)args[1]);
                Optional<Passport> other = this.service.getPassport(showTarget.getUniqueId());
                if (!other.isPresent()) {
                    sender.sendMessage(this.msg("messages.passport-not-found"));
                    return true;
                }
                this.service.openPassport(viewer, other.get());
                return true;
            }
            case "ask": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.msg("messages.player-only"));
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(this.msg("messages.ask-usage"));
                    return true;
                }
                Player requester = (Player)sender;
                Player askTarget = Bukkit.getPlayerExact((String)args[1]);
                if (askTarget == null) {
                    requester.sendMessage(this.color("&c\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u043e\u043d\u043b\u0430\u0439\u043d."));
                    return true;
                }
                if (askTarget.getUniqueId().equals(requester.getUniqueId())) {
                    requester.sendMessage(this.color("&c\u041d\u0435\u043b\u044c\u0437\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0438\u0442\u044c \u043f\u0430\u0441\u043f\u043e\u0440\u0442 \u0443 \u0441\u0430\u043c\u043e\u0433\u043e \u0441\u0435\u0431\u044f."));
                    return true;
                }
                this.askManager.sendAsk(requester, askTarget);
                requester.sendMessage(this.msg("messages.ask-sent").replace("%player%", askTarget.getName()));
                return true;
            }
            case "approve": 
            case "deny": {
                Player reqPlayer;
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.msg("messages.player-only"));
                    return true;
                }
                Player targetPlayer = (Player)sender;
                if (!this.askManager.hasRequest(targetPlayer)) {
                    targetPlayer.sendMessage(this.msg("messages.ask-expired"));
                    return true;
                }
                UUID requesterUuid = this.askManager.consumeIfApprovedPossible(targetPlayer);
                this.askManager.remove(targetPlayer);
                Player player = reqPlayer = requesterUuid == null ? null : Bukkit.getPlayer((UUID)requesterUuid);
                if (reqPlayer == null) {
                    targetPlayer.sendMessage(this.color("&c\u0417\u0430\u043f\u0440\u043e\u0441\u0438\u0432\u0448\u0438\u0439 \u0438\u0433\u0440\u043e\u043a \u043d\u0435 \u043e\u043d\u043b\u0430\u0439\u043d."));
                    return true;
                }
                if (sub.equals("deny")) {
                    targetPlayer.sendMessage(this.msg("messages.ask-denied"));
                    reqPlayer.sendMessage(this.msg("messages.ask-denied"));
                    return true;
                }
                Optional<Passport> pass = this.service.getPassport(targetPlayer.getUniqueId());
                if (!pass.isPresent()) {
                    reqPlayer.sendMessage(this.msg("messages.passport-not-found"));
                    targetPlayer.sendMessage(this.msg("messages.passport-not-found"));
                    return true;
                }
                targetPlayer.sendMessage(this.msg("messages.ask-approved"));
                reqPlayer.sendMessage(this.msg("messages.ask-approved"));
                this.service.openPassport(reqPlayer, pass.get());
                return true;
            }
        }
        this.sendHelp(sender);
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(this.color("&6--- &eInfPassport &6---"));
        sender.sendMessage(this.color("&e/passport show &7- \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u0432\u043e\u0439 \u043f\u0430\u0441\u043f\u043e\u0440\u0442 (\u0432 \u043a\u043d\u0438\u0433\u0435)."));
        sender.sendMessage(this.color("&e/passport ask <\u043d\u0438\u043a> &7- \u041f\u043e\u043f\u0440\u043e\u0441\u0438\u0442\u044c \u0438\u0433\u0440\u043e\u043a\u0430 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043f\u0430\u0441\u043f\u043e\u0440\u0442."));
        if (sender.hasPermission("infpassport.new")) {
            sender.sendMessage(this.color("&e/passport new <\u043d\u0438\u043a> <\u0438\u043c\u044f> <\u043f\u043e\u043b> <\u0434\u0430\u0442\u0430_\u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f> &7- \u0412\u044b\u0434\u0430\u0442\u044c \u043f\u0430\u0441\u043f\u043e\u0440\u0442 (DD.MM.YYYY)."));
        }
        if (sender.hasPermission("infpassport.delete")) {
            sender.sendMessage(this.color("&e/passport delete <\u043d\u0438\u043a> &7- \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0430\u0441\u043f\u043e\u0440\u0442 \u0438\u0433\u0440\u043e\u043a\u0430."));
        }
        if (sender.hasPermission("infpassport.edit")) {
            sender.sendMessage(this.color("&e/passport edit <gender|marital|name|birthdate> <\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435> &7- \u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043e\u043b\u044f \u0441\u0432\u043e\u0435\u0433\u043e \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430."));
        }
        if (sender.hasPermission("infpassport.show")) {
            sender.sendMessage(this.color("&e/passport show <\u043d\u0438\u043a> &7- \u041f\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u043f\u0430\u0441\u043f\u043e\u0440\u0442 \u0434\u0440\u0443\u0433\u043e\u0433\u043e \u0438\u0433\u0440\u043e\u043a\u0430."));
        }
        if (sender.hasPermission("infpassport.reload")) {
            sender.sendMessage(this.color("&e/passport reload &7- \u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433 (\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f)."));
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return Collections.emptyList();
    }

    private String msg(String path) {
        String prefix = this.plugin.getConfig().getString("messages.prefix", "&6[InfPassport]&r ");
        String raw = this.plugin.getConfig().getString(path, "&cMissing message: " + path);
        return this.color(prefix + raw);
    }

    private String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }
}

