/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.InfPassport.db;

import com.masterok.InfPassport.model.Passport;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import org.bukkit.plugin.java.JavaPlugin;

public class PassportDatabase {
    private final JavaPlugin plugin;
    private Connection connection;

    public PassportDatabase(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void init() {
        try {
            File dataFolder = this.plugin.getDataFolder();
            if (!dataFolder.exists()) {
                dataFolder.mkdirs();
            }
            String fileName = this.plugin.getConfig().getString("database.file", "passports.db");
            File dbFile = new File(dataFolder, fileName);
            String url = "jdbc:sqlite:" + dbFile.getAbsolutePath();
            this.connection = DriverManager.getConnection(url);
            try (Statement st = this.connection.createStatement();){
                st.executeUpdate("CREATE TABLE IF NOT EXISTS passports (owner_uuid TEXT PRIMARY KEY,owner_name TEXT NOT NULL,real_name TEXT NOT NULL,birth_date TEXT NOT NULL,age TEXT NOT NULL,gender TEXT NOT NULL,marital_status TEXT NOT NULL,issued_at INTEGER NOT NULL,issued_by_uuid TEXT NOT NULL,issued_by_name TEXT NOT NULL)");
                try {
                    st.executeUpdate("ALTER TABLE passports ADD COLUMN birth_date TEXT NOT NULL DEFAULT '\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430'");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to init database: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<Passport> getPassportByOwnerUuid(String ownerUuid) {
        String sql = "SELECT * FROM passports WHERE owner_uuid = ?";
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            Optional<Passport> optional;
            block18: {
                ResultSet rs;
                block16: {
                    Optional<Passport> optional2;
                    block17: {
                        ps.setString(1, ownerUuid);
                        rs = ps.executeQuery();
                        try {
                            if (rs.next()) break block16;
                            optional2 = Optional.empty();
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return optional2;
                }
                Passport p = new Passport(rs.getString("owner_uuid"), rs.getString("owner_name"), rs.getString("real_name"), rs.getString("birth_date"), rs.getString("age"), rs.getString("gender"), rs.getString("marital_status"), rs.getLong("issued_at"), rs.getString("issued_by_uuid"), rs.getString("issued_by_name"));
                optional = Optional.of(p);
                if (rs == null) break block18;
                rs.close();
            }
            return optional;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("DB getPassport error: " + e.getMessage());
            return Optional.empty();
        }
    }

    public void upsertPassport(Passport passport) {
        String sql = "INSERT INTO passports(owner_uuid, owner_name, real_name, birth_date, age, gender, marital_status, issued_at, issued_by_uuid, issued_by_name) VALUES(?,?,?,?,?,?,?,?,?,?) ON CONFLICT(owner_uuid) DO UPDATE SET owner_name=excluded.owner_name, real_name=excluded.real_name, birth_date=excluded.birth_date, age=excluded.age, gender=excluded.gender, marital_status=excluded.marital_status, issued_at=excluded.issued_at, issued_by_uuid=excluded.issued_by_uuid, issued_by_name=excluded.issued_by_name";
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            ps.setString(1, passport.getOwnerUuid());
            ps.setString(2, passport.getOwnerName());
            ps.setString(3, passport.getRealName());
            ps.setString(4, passport.getBirthDate());
            ps.setString(5, passport.getAge());
            ps.setString(6, passport.getGender());
            ps.setString(7, passport.getMaritalStatus());
            ps.setLong(8, passport.getIssuedAtEpochMillis());
            ps.setString(9, passport.getIssuedByUuid());
            ps.setString(10, passport.getIssuedByName());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("DB upsertPassport error: " + e.getMessage());
        }
    }

    public boolean deletePassport(String ownerUuid) {
        boolean bl;
        block8: {
            String sql = "DELETE FROM passports WHERE owner_uuid = ?";
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                ps.setString(1, ownerUuid);
                boolean bl2 = bl = ps.executeUpdate() > 0;
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.getLogger().severe("DB deletePassport error: " + e.getMessage());
                    return false;
                }
            }
            ps.close();
        }
        return bl;
    }

    public void updateField(String ownerUuid, String field, String value) {
        if (!(field.equals("age") || field.equals("gender") || field.equals("marital_status") || field.equals("real_name") || field.equals("birth_date"))) {
            return;
        }
        String sql = "UPDATE passports SET " + field + " = ? WHERE owner_uuid = ?";
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            ps.setString(1, value);
            ps.setString(2, ownerUuid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("DB updateField error: " + e.getMessage());
        }
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

