/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.InfPassport.service;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AskManager {
    private final JavaPlugin plugin;
    private final Map<UUID, AskRequest> requests = new ConcurrentHashMap<UUID, AskRequest>();
    private final long ttlMillis = 60000L;

    public AskManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void sendAsk(Player requester, final Player target) {
        this.requests.put(target.getUniqueId(), new AskRequest(requester.getUniqueId(), System.currentTimeMillis()));
        String received = this.plugin.getConfig().getString("messages.ask-received", "&e\u0418\u0433\u0440\u043e\u043a &6%requester% &e\u043f\u0440\u043e\u0441\u0438\u0442 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043f\u0430\u0441\u043f\u043e\u0440\u0442.").replace("%requester%", requester.getName());
        target.sendMessage(this.color(received));
        TextComponent line = new TextComponent("");
        TextComponent allow = new TextComponent("[\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c]");
        allow.setColor(net.md_5.bungee.api.ChatColor.GREEN);
        allow.setBold(Boolean.valueOf(true));
        allow.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/passport approve"));
        allow.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u041d\u0430\u0436\u043c\u0438, \u0447\u0442\u043e\u0431\u044b \u0440\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c").color(net.md_5.bungee.api.ChatColor.GRAY).create()));
        TextComponent space = new TextComponent(" ");
        TextComponent deny = new TextComponent("[\u041e\u0442\u043a\u0430\u0437\u0430\u0442\u044c]");
        deny.setColor(net.md_5.bungee.api.ChatColor.RED);
        deny.setBold(Boolean.valueOf(true));
        deny.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/passport deny"));
        deny.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u041d\u0430\u0436\u043c\u0438, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043a\u0430\u0437\u0430\u0442\u044c").color(net.md_5.bungee.api.ChatColor.GRAY).create()));
        line.addExtra((BaseComponent)allow);
        line.addExtra((BaseComponent)space);
        line.addExtra((BaseComponent)deny);
        target.spigot().sendMessage((BaseComponent)line);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                AskRequest r = (AskRequest)AskManager.this.requests.get(target.getUniqueId());
                if (r != null && AskManager.this.isExpired(r)) {
                    AskManager.this.requests.remove(target.getUniqueId());
                }
            }
        }, 1200L);
    }

    public UUID consumeIfApprovedPossible(Player target) {
        AskRequest r = this.requests.get(target.getUniqueId());
        if (r == null) {
            return null;
        }
        if (this.isExpired(r)) {
            this.requests.remove(target.getUniqueId());
            return null;
        }
        return r.requesterUuid;
    }

    public void remove(Player target) {
        this.requests.remove(target.getUniqueId());
    }

    public boolean hasRequest(Player target) {
        AskRequest r = this.requests.get(target.getUniqueId());
        return r != null && !this.isExpired(r);
    }

    private boolean isExpired(AskRequest r) {
        return System.currentTimeMillis() - r.createdAtMillis > 60000L;
    }

    private String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    private static class AskRequest {
        final UUID requesterUuid;
        final long createdAtMillis;

        AskRequest(UUID requesterUuid, long createdAtMillis) {
            this.requesterUuid = requesterUuid;
            this.createdAtMillis = createdAtMillis;
        }
    }
}

