/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.InfPassport.service;

import com.masterok.InfPassport.db.PassportDatabase;
import com.masterok.InfPassport.model.Passport;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class PassportService {
    private final JavaPlugin plugin;
    private final PassportDatabase db;

    public PassportService(JavaPlugin plugin, PassportDatabase db) {
        this.plugin = plugin;
        this.db = db;
    }

    public Optional<Passport> getPassport(UUID ownerUuid) {
        return this.db.getPassportByOwnerUuid(ownerUuid.toString());
    }

    public BirthdateCheck validateBirthdate(String birthDateStr) {
        BirthdateCheck res = new BirthdateCheck();
        res.ok = false;
        LocalDate birth = this.parseBirthdate(birthDateStr);
        if (birth == null) {
            res.errorKey = "messages.birthdate-invalid";
            return res;
        }
        int minAge = this.plugin.getConfig().getInt("rules.min-age", 14);
        int age = this.calculateAgeYears(birth, LocalDate.now());
        if (age < minAge) {
            res.errorKey = "messages.birthdate-too-young";
            res.minAge = minAge;
            return res;
        }
        res.ok = true;
        res.birthIso = birth.toString();
        res.ageYears = age;
        return res;
    }

    public void createPassport(Player issuer, OfflinePlayer target, String realName, String gender, String birthIso) {
        LocalDate birth = LocalDate.parse(birthIso);
        int ageYears = this.calculateAgeYears(birth, LocalDate.now());
        Passport passport = new Passport(target.getUniqueId().toString(), target.getName() == null ? "Unknown" : target.getName(), realName, birthIso, String.valueOf(ageYears), gender, this.plugin.getConfig().getString("defaults.marital", "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e"), System.currentTimeMillis(), issuer.getUniqueId().toString(), issuer.getName());
        this.db.upsertPassport(passport);
    }

    public boolean deletePassport(UUID ownerUuid) {
        return this.db.deletePassport(ownerUuid.toString());
    }

    public void editField(UUID ownerUuid, String field, String value) {
        String f = field.toLowerCase(Locale.ROOT);
        String dbField = null;
        if (f.equals("gender")) {
            dbField = "gender";
        } else if (f.equals("marital")) {
            dbField = "marital_status";
        } else if (f.equals("name")) {
            dbField = "real_name";
        } else if (f.equals("birthdate") || f.equals("birth")) {
            dbField = "birth_date";
        }
        if (dbField == null) {
            return;
        }
        this.db.updateField(ownerUuid.toString(), dbField, value);
    }

    public ItemStack buildPassportBook(Passport p) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK, 1);
        BookMeta meta = (BookMeta)book.getItemMeta();
        String title = this.plugin.getConfig().getString("book.title", "\u041f\u0430\u0441\u043f\u043e\u0440\u0442");
        String author = this.plugin.getConfig().getString("book.author", "InfPassport");
        meta.setTitle(title);
        meta.setAuthor(author);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String issuedAt = sdf.format(new Date(p.getIssuedAtEpochMillis()));
        String header = "&8&l\u1d18\u1d00\ua731\ua731\u1d18\u1d0f\u0280\u1d1b&r";
        String birthPretty = this.toPrettyBirthdate(p.getBirthDate());
        ArrayList<String> page1 = new ArrayList<String>();
        page1.add(this.color(header));
        page1.add(this.color("&7----------------"));
        page1.add(this.color("&8\u0418\u043c\u044f: &7" + p.getRealName()));
        page1.add(this.color("&8\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f: &7" + birthPretty));
        page1.add(this.color("&8\u041f\u043e\u043b: &7" + p.getGender()));
        page1.add(this.color("&8\u0421\u0435\u043c\u0435\u0439\u043d\u043e\u0435 \u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435: &7" + p.getMaritalStatus()));
        page1.add("");
        page1.add(this.color("&8\u0412\u044b\u0434\u0430\u043d: &7" + issuedAt));
        page1.add(this.color("&8\u041a\u0435\u043c: &7" + p.getIssuedByName()));
        meta.setPages(new String[]{String.join((CharSequence)"\n", page1)});
        book.setItemMeta((ItemMeta)meta);
        return book;
    }

    public void openPassport(Player viewer, Passport passport) {
        ItemStack book = this.buildPassportBook(passport);
        viewer.openBook(book);
    }

    private int calculateAgeYears(LocalDate birth, LocalDate now) {
        return Period.between(birth, now).getYears();
    }

    private LocalDate parseBirthdate(String s) {
        if (s == null) {
            return null;
        }
        String[] parts = s.trim().split("\\.");
        if (parts.length != 3) {
            return null;
        }
        try {
            int dd = Integer.parseInt(parts[0]);
            int mm = Integer.parseInt(parts[1]);
            int yyyy = Integer.parseInt(parts[2]);
            if (dd < 1 || dd > 31) {
                return null;
            }
            if (mm < 1 || mm > 12) {
                return null;
            }
            if (yyyy < 1900 || yyyy > 2100) {
                return null;
            }
            return LocalDate.of(yyyy, mm, dd);
        }
        catch (NumberFormatException e) {
            return null;
        }
        catch (DateTimeException e) {
            return null;
        }
    }

    private String toPrettyBirthdate(String iso) {
        try {
            LocalDate d = LocalDate.parse(iso);
            int dd = d.getDayOfMonth();
            int mm = d.getMonthValue();
            int yyyy = d.getYear();
            return this.two(dd) + "." + this.two(mm) + "." + yyyy;
        }
        catch (Exception e) {
            return iso;
        }
    }

    private String two(int n) {
        return (n < 10 ? "0" : "") + n;
    }

    private String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public static class BirthdateCheck {
        public boolean ok;
        public String errorKey;
        public String birthIso;
        public int ageYears;
        public int minAge;
    }
}

