/*
 * Decompiled with CFR 0.152.
 */
package com.masterok.InfPassport.service;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private final String url;

    public UpdateChecker(JavaPlugin plugin, String url) {
        this.plugin = plugin;
        this.url = url;
    }

    public void checkAsync(final CommandSender notifyTo) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                UpdateInfo info = UpdateChecker.this.fetch();
                if (info == null) {
                    if (notifyTo != null) {
                        notifyTo.sendMessage("\u00a76[InfPassport] \u00a7c\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f (\u0441\u043c. \u043a\u043e\u043d\u0441\u043e\u043b\u044c).");
                    }
                    return;
                }
                String current = UpdateChecker.this.safe(UpdateChecker.this.plugin.getDescription().getVersion());
                String latest = UpdateChecker.this.safe(info.latestVersion);
                if (latest.isEmpty()) {
                    return;
                }
                boolean newer = UpdateChecker.this.isNewer(latest, current);
                if (newer) {
                    String msg = "[InfPassport] Update available: " + current + " -> " + latest + (info.downloadUrl.isEmpty() ? "" : " | Download: " + info.downloadUrl);
                    UpdateChecker.this.plugin.getLogger().warning(msg);
                    if (notifyTo != null) {
                        notifyTo.sendMessage("\u00a76[InfPassport] \u00a7e\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435: \u00a7c" + current + " \u00a7e-> \u00a7a" + latest);
                        if (!info.downloadUrl.isEmpty()) {
                            notifyTo.sendMessage("\u00a76[InfPassport] \u00a7e\u0421\u0441\u044b\u043b\u043a\u0430: \u00a7b" + info.downloadUrl);
                        }
                    }
                } else if (notifyTo != null) {
                    notifyTo.sendMessage("\u00a76[InfPassport] \u00a7a\u0423 \u0442\u0435\u0431\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0432\u0435\u0440\u0441\u0438\u044f: \u00a7e" + current);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateInfo fetch() {
        HttpURLConnection conn = null;
        try {
            String linkLine;
            String versionLine;
            BufferedReader br;
            block15: {
                UpdateInfo updateInfo;
                conn = (HttpURLConnection)new URL(this.url).openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(6000);
                conn.setReadTimeout(6000);
                conn.setRequestProperty("User-Agent", "Mozilla/5.0 (InfPassport UpdateChecker)");
                int code = conn.getResponseCode();
                if (code != 200) {
                    this.plugin.getLogger().warning("Update check failed: HTTP " + code + " from " + this.url);
                    UpdateInfo updateInfo2 = null;
                    return updateInfo2;
                }
                br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                try {
                    versionLine = this.stripBom(this.safe(br.readLine()));
                    linkLine = this.safe(br.readLine());
                    this.plugin.getLogger().info("[InfPassport] Update check: remoteVersion='" + versionLine + "', remoteLink='" + linkLine + "'");
                    if (!versionLine.isEmpty()) break block15;
                    updateInfo = null;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().log(Level.WARNING, "Update check failed: " + e.getMessage());
                        UpdateInfo updateInfo3 = null;
                        return updateInfo3;
                    }
                }
                br.close();
                return updateInfo;
            }
            UpdateInfo info = new UpdateInfo();
            info.latestVersion = versionLine;
            info.downloadUrl = linkLine;
            UpdateInfo updateInfo = info;
            br.close();
            return updateInfo;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private boolean isNewer(String remote, String local) {
        String l;
        String r = this.safe(remote);
        if (r.equalsIgnoreCase(l = this.safe(local))) {
            return false;
        }
        if (this.containsLetters(r) || this.containsLetters(l)) {
            return true;
        }
        int[] rn = this.parseNumeric(r);
        int[] ln = this.parseNumeric(l);
        if (rn.length == 0 || ln.length == 0) {
            return true;
        }
        int max = Math.max(rn.length, ln.length);
        for (int i = 0; i < max; ++i) {
            int lv;
            int rv = i < rn.length ? rn[i] : 0;
            int n = lv = i < ln.length ? ln[i] : 0;
            if (rv > lv) {
                return true;
            }
            if (rv >= lv) continue;
            return false;
        }
        return false;
    }

    private boolean containsLetters(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) continue;
            return true;
        }
        return false;
    }

    private int[] parseNumeric(String v) {
        if (v == null) {
            return new int[0];
        }
        String clean = v.replace("\ufeff", "").replaceAll("[^0-9.]", "").trim();
        if (clean.isEmpty()) {
            return new int[0];
        }
        String[] parts = clean.split("\\.");
        int[] out = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                out[i] = Integer.parseInt(parts[i]);
                continue;
            }
            catch (NumberFormatException e) {
                out[i] = 0;
            }
        }
        return out;
    }

    private String stripBom(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\ufeff", "").trim();
    }

    private String safe(String s) {
        return s == null ? "" : s.trim();
    }

    private static class UpdateInfo {
        String latestVersion;
        String downloadUrl;

        private UpdateInfo() {
        }
    }
}

